/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.common.util.XMLWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reveng {
    private static final String SCHEMA_SELECTION_ELEMENT = "schema-selection";
    private static final String PACKAGE_ATTR = "package";
    private static final String MATCH_NAME_ATTR = "match-name";
    private static final String TABLE_FILTER_ELEMENT = "table-filter";
    private static final String MATCH_SCHEMA_ATTR = "match-schema";
    private static final String EXCLUDE_ATTR = "exclude";
    private static final String EXCLUDE_CHAR = "^";
    private static final String ESCAPE_CHAR = "\\";
    private String packageName;
    private List<String> tableFilters = new ArrayList<String>();
    private List<String> schemaFilters = new ArrayList<String>();

    public static Reveng load(Reader reader) {
        Reveng rtn = new Reveng();
        XMLStreamReader xmlReader = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            xmlReader = factory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        try {
            int event = xmlReader.next();
            while (event != 8) {
                switch (event) {
                    case 1: {
                        Map attrs;
                        if (xmlReader.getName().toString().equals(TABLE_FILTER_ELEMENT)) {
                            attrs = XMLUtils.attributesToMap((XMLStreamReader)xmlReader);
                            rtn.packageName = (String)attrs.get(PACKAGE_ATTR);
                            rtn.tableFilters = new ArrayList<String>();
                            rtn.tableFilters.add((String)attrs.get(MATCH_NAME_ATTR));
                            break;
                        }
                        if (!xmlReader.getName().toString().equals(SCHEMA_SELECTION_ELEMENT)) break;
                        attrs = XMLUtils.attributesToMap((XMLStreamReader)xmlReader);
                        rtn.schemaFilters = new ArrayList<String>();
                        rtn.schemaFilters.add((String)attrs.get(MATCH_SCHEMA_ATTR));
                        break;
                    }
                }
                event = xmlReader.next();
            }
            xmlReader.close();
        }
        catch (XMLStreamException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return rtn;
    }

    public Reveng() {
        this.tableFilters.add(".*");
        this.schemaFilters.add(".*");
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setTableFilters(List<String> tableFilters) {
        this.tableFilters = tableFilters;
    }

    public void setSchemaFilters(List<String> schemaFilters) {
        this.schemaFilters = schemaFilters;
    }

    public List<String> getTableFilters() {
        return this.tableFilters;
    }

    public List<String> getSchemaFilters() {
        return this.schemaFilters;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void write(PrintWriter writer) {
        XMLWriter xmlWriter = XMLUtils.newXMLWriter((PrintWriter)writer);
        xmlWriter.addDoctype("hibernate-reverse-engineering", null, "http://hibernate.sourceforge.net/hibernate-reverse-engineering-3.0.dtd");
        xmlWriter.addElement("hibernate-reverse-engineering");
        for (String s : this.schemaFilters) {
            xmlWriter.addClosedElement(SCHEMA_SELECTION_ELEMENT, new String[]{MATCH_SCHEMA_ATTR, XMLUtils.escape((String)s)});
        }
        ArrayList<String> includeFilters = new ArrayList<String>();
        ArrayList<String> excludeFilters = new ArrayList<String>();
        this.populateTableFilters(includeFilters, excludeFilters);
        if (includeFilters.isEmpty()) {
            includeFilters.add(".*");
        }
        for (String filter : excludeFilters) {
            this.addTableFilterElement(xmlWriter, filter, true);
        }
        for (String filter : includeFilters) {
            this.addTableFilterElement(xmlWriter, filter, false);
        }
        xmlWriter.finish();
    }

    private void addTableFilterElement(XMLWriter xmlWriter, String filter, boolean exclude) {
        xmlWriter.addElement(TABLE_FILTER_ELEMENT, new String[]{MATCH_NAME_ATTR, XMLUtils.escape((String)filter), EXCLUDE_ATTR, String.valueOf(exclude)});
        if (!exclude) {
            xmlWriter.addAttribute(PACKAGE_ATTR, XMLUtils.escape((String)this.packageName));
        }
        xmlWriter.closeElement();
    }

    private void populateTableFilters(List<String> includeFilters, List<String> excludeFilters) {
        for (String filter : this.tableFilters) {
            boolean exclude = false;
            if (filter.startsWith(ESCAPE_CHAR)) {
                filter = filter.substring(ESCAPE_CHAR.length());
            } else if (filter.startsWith(EXCLUDE_CHAR)) {
                filter = filter.substring(EXCLUDE_CHAR.length());
                exclude = true;
            }
            if (exclude) {
                excludeFilters.add(filter);
                continue;
            }
            includeFilters.add(filter);
        }
    }
}

