/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.HibernateConfigurationExporter;

public class WMHibernateConfigurationExporter
extends HibernateConfigurationExporter {
    private Writer output = null;
    private Properties customProperties = null;

    public void setOutput(Writer output) {
        super.setOutput(output);
        this.output = output;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    public void doStart() throws ExporterException {
        PrintWriter pw = null;
        File file = null;
        try {
            if (this.output == null) {
                file = new File(this.getOutputDirectory(), "hibernate.cfg.xml");
                this.getTemplateHelper().ensureExistence(file);
                pw = new PrintWriter(new FileWriter(file));
                this.getArtifactCollector().addFile(file, "cfg.xml");
            } else {
                pw = new PrintWriter(this.output);
            }
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE hibernate-configuration PUBLIC\r\n               \"-//Hibernate/Hibernate Configuration DTD 3.0//EN\"\r\n               \"http://hibernate.sourceforge.net/hibernate-configuration-3.0.dtd\">\r\n<hibernate-configuration>");
            boolean ejb3 = Boolean.valueOf((String)this.getProperties().get("ejb3"));
            TreeMap<Object, Object> props = new TreeMap<Object, Object>();
            if (this.getConfiguration() != null) {
                props.putAll(this.getConfiguration().getProperties());
            }
            if (this.customProperties != null) {
                props.putAll(this.customProperties);
            }
            String sfname = (String)props.get("hibernate.session_factory_name");
            pw.println("    <session-factory" + (sfname == null ? "" : " name=\"" + sfname + "\"") + ">");
            HashMap<String, String> ignoredProperties = new HashMap<String, String>();
            ignoredProperties.put("hibernate.session_factory_name", null);
            ignoredProperties.put("hibernate.hbm2ddl.auto", "false");
            ignoredProperties.put("hibernate.temp.use_jdbc_metadata_defaults", null);
            Set set = props.entrySet();
            for (Map.Entry element : set) {
                Object ignoredValue;
                String key = (String)element.getKey();
                if (ignoredProperties.containsKey(key) && ((ignoredValue = ignoredProperties.get(key)) == null || element.getValue().equals(ignoredValue)) || !key.startsWith("hibernate.")) continue;
                pw.println("        <property name=\"" + key + "\">" + element.getValue() + "</property>");
            }
            if (this.getConfiguration() != null) {
                PersistentClass element;
                Iterator classMappings = this.getConfiguration().getClassMappings();
                while (classMappings.hasNext()) {
                    element = (PersistentClass)classMappings.next();
                    if (!(element instanceof RootClass)) continue;
                    this.dump(pw, ejb3, element);
                }
                pw.println();
                pw.println();
                classMappings = this.getConfiguration().getClassMappings();
                while (classMappings.hasNext()) {
                    element = (PersistentClass)classMappings.next();
                    if (!(element instanceof RootClass)) continue;
                    this.dumpQueryFile(pw, element);
                }
            }
            pw.println("    </session-factory>\r\n</hibernate-configuration>");
        }
        catch (IOException e) {
            throw new ExporterException("Problems while creating hibernate.cfg.xml", (Throwable)e);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    private void dump(PrintWriter pw, boolean useClass, PersistentClass element) {
        if (useClass) {
            pw.println("<mapping class=\"" + element.getClassName() + "\"/>");
        } else {
            pw.println("<mapping resource=\"" + this.getMappingFileResource(element) + "\"/>");
        }
        Iterator directSubclasses = element.getDirectSubclasses();
        while (directSubclasses.hasNext()) {
            PersistentClass subclass = (PersistentClass)directSubclasses.next();
            this.dump(pw, useClass, subclass);
        }
    }

    private void dumpQueryFile(PrintWriter pw, PersistentClass element) {
        String relPath = this.getQueryFileResource(element);
        pw.println("<mapping resource=\"" + relPath + "\"/>");
    }

    private String getMappingFileResource(PersistentClass element) {
        return element.getClassName().replace('.', '/') + ".hbm.xml";
    }

    private String getQueryFileResource(PersistentClass element) {
        return element.getClassName().replace('.', '/') + ".ql.xml";
    }
}

