/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.parser;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.EntityInfo;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.parser.BaseHbmParser;
import com.wavemaker.tools.data.parser.HbmConstants;
import java.io.File;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbmParser
extends BaseHbmParser {
    private EntityInfo entity = null;
    private boolean initializedProperties = false;

    public HbmParser() {
    }

    public HbmParser(String s) {
        super(s);
    }

    public HbmParser(File f) {
        super(f);
    }

    public HbmParser(Reader reader) {
        super(reader);
    }

    @Override
    public synchronized void initAll() {
        this.getProperties();
    }

    public synchronized EntityInfo getEntity() {
        if (this.entity == null) {
            this.initEntity();
        }
        return this.entity;
    }

    public synchronized Map<String, PropertyInfo> getPropertiesMap() {
        this.getProperties();
        return this.entity.getPropertiesMap();
    }

    public synchronized Collection<PropertyInfo> getProperties() {
        this.getEntity();
        if (!this.initializedProperties) {
            this.initializedProperties = true;
            this.initProperties();
            this.close();
        }
        return this.entity.getProperties();
    }

    private void initEntity() {
        this.next("class");
        Map attrs = XMLUtils.attributesToMap((XMLStreamReader)this.xmlReader);
        Tuple.Two t = StringUtils.splitPackageAndClass((String)((String)attrs.get("name")));
        String schema = (String)attrs.get("schema");
        String catalog = (String)attrs.get("catalog");
        this.entity = new EntityInfo((String)t.v1, (String)t.v2, (String)attrs.get("table"), schema, catalog);
        this.entity.setDynamicInsert(this.getBoolValue("dynamic-insert", attrs));
        this.entity.setDynamicUpdate(this.getBoolValue("dynamic-update", attrs));
    }

    private boolean getBoolValue(String key, Map<String, String> attrs) {
        boolean rtn = false;
        if (attrs.containsKey(key)) {
            rtn = Boolean.valueOf(attrs.get(key));
        }
        return rtn;
    }

    private void initProperties() {
        String propertyKind = "";
        while (propertyKind != null && (propertyKind = this.next("composite-id", "id", "many-to-one", "property", "set", "component")) != null) {
            PropertyInfo p = this.initProperty(propertyKind);
            if (p.getIsRelated()) {
                this.entity.addRelatedProperty(p);
            } else {
                this.entity.addProperty(p);
            }
            if (!p.getIsId()) continue;
            this.entity.setId(p);
        }
    }

    private PropertyInfo initProperty(String propertyKind) {
        Map propertyAttrs = XMLUtils.attributesToMap((XMLStreamReader)this.xmlReader);
        PropertyInfo rtn = PropertyInfo.fromKind(propertyKind, propertyAttrs);
        if (HbmConstants.PROP_WRAPPER_ELS.contains(propertyKind)) {
            String nestedPropertyKind = "";
            while (nestedPropertyKind != null && (nestedPropertyKind = this.nextNested(propertyKind, "key-property", "property")) != null) {
                PropertyInfo p = this.initProperty(nestedPropertyKind);
                rtn.addCompositeProperty(p);
            }
        } else {
            Tuple.Two<Collection<ColumnInfo>, Map<String, String>> t = this.initColumns(rtn, propertyKind);
            Collection columns = (Collection)t.v1;
            Map nestedAttributes = (Map)t.v2;
            if (columns.size() == 1) {
                rtn.setColumn((ColumnInfo)columns.iterator().next());
            } else {
                for (ColumnInfo ci : columns) {
                    PropertyInfo p = PropertyInfo.fromKind(propertyKind, nestedAttributes);
                    p.setName(ci.getName());
                    p.setColumn(ci);
                    rtn.addCompositeProperty(p);
                }
            }
            if (rtn.getIsInverse()) {
                rtn.types((String)nestedAttributes.get(HbmConstants.FQ_TO_MANY_TYPE_ATTR));
            }
        }
        return rtn;
    }

    private Tuple.Two<Collection<ColumnInfo>, Map<String, String>> initColumns(PropertyInfo parentProperty, String parentElementName) {
        String nestedElement = "";
        LinkedHashMap<String, ColumnInfo> rtnMap = new LinkedHashMap<String, ColumnInfo>();
        HashMap<String, String> attributes = new HashMap<String, String>();
        while (nestedElement != null && (nestedElement = this.nextNested(parentElementName, "column", "generator", "one-to-many")) != null) {
            Map attrs = XMLUtils.attributesToMap((String)nestedElement, (XMLStreamReader)this.xmlReader);
            if ((parentElementName.equals("many-to-one") || parentElementName.equals("set")) && attrs.containsKey(HbmConstants.FQ_COL_NAME_ATTR)) {
                ColumnInfo ci = ColumnInfo.newColumnInfo(parentProperty, attrs);
                rtnMap.put(ci.getName(), ci);
            }
            attributes.putAll(attrs);
            if (!nestedElement.equals("generator")) continue;
            String s = "";
            while (s != null && (s = this.nextNested("generator", "param")) != null) {
                Map m = XMLUtils.attributesToMap((XMLStreamReader)this.xmlReader);
                String paramName = null;
                if (m.containsKey("name")) {
                    paramName = "param." + (String)m.get("name");
                }
                this.nextCharacterData();
                if (paramName == null || this.currentText.length() <= 0) continue;
                attributes.put(paramName, this.currentText.toString());
            }
        }
        ColumnInfo ci2 = ColumnInfo.newColumnInfo(parentProperty, attributes);
        if (!rtnMap.containsKey(ci2.getName())) {
            rtnMap.put(ci2.getName(), ci2);
        }
        return Tuple.tuple(rtnMap.values(), attributes);
    }
}

