/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.parser;

import com.wavemaker.common.util.Tuple;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.tools.data.QueryInfo;
import com.wavemaker.tools.data.parser.BaseHbmParser;
import java.io.File;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbmQueryParser
extends BaseHbmParser {
    private String meta = null;
    private boolean metaInitialized = false;
    private Map<String, QueryInfo> queries = null;

    public HbmQueryParser(String s) {
        super(s);
    }

    public HbmQueryParser(File f) {
        super(f);
    }

    public HbmQueryParser(Reader reader) {
        super(reader);
    }

    @Override
    public void initAll() {
        this.getQueries();
    }

    public synchronized String getMeta() {
        if (!this.metaInitialized) {
            this.metaInitialized = true;
            this.initMeta();
        }
        return this.meta;
    }

    public synchronized Map<String, QueryInfo> getQueries() {
        this.getMeta();
        if (this.queries == null) {
            this.queries = new LinkedHashMap<String, QueryInfo>();
            this.initQueries();
            this.close();
        }
        return this.queries;
    }

    private void initMeta() {
        this.next("hibernate-mapping");
        String found = this.next();
        if (!"meta".equals(found)) {
            return;
        }
        Map attrs = XMLUtils.attributesToMap((XMLStreamReader)this.xmlReader);
        this.meta = (String)attrs.get("attribute");
    }

    private void initQueries() {
        QueryInfo q = null;
        if ("query".equals(String.valueOf(this.currentElementName))) {
            q = this.initQuery(this.currentElementName);
            this.queries.put(q.getName(), q);
        }
        String queryKind = "";
        while (queryKind != null && (queryKind = this.nextNested("hibernate-mapping", "query")) != null) {
            q = this.initQuery(queryKind);
            this.queries.put(q.getName(), q);
        }
    }

    private QueryInfo initQuery(String queryKind) {
        Map queryAttrs = XMLUtils.attributesToMap((XMLStreamReader)this.xmlReader);
        QueryInfo rtn = new QueryInfo();
        rtn.setIsHQL(true);
        rtn.setName((String)queryAttrs.get("name"));
        String comment = (String)queryAttrs.get("comment");
        rtn.setIsGenerated(com.wavemaker.tools.data.util.DataServiceUtils.isGeneratedQuery(comment));
        rtn.setComment(com.wavemaker.tools.data.util.DataServiceUtils.sanitizeComment(comment));
        this.addQueryParams(queryKind, rtn);
        rtn.setQuery(this.currentText.toString().trim());
        return rtn;
    }

    private void addQueryParams(String queryKind, QueryInfo query) {
        String s = "";
        while (s != null && (s = this.nextNested(queryKind, "query-param")) != null) {
            Map attrs = XMLUtils.attributesToMap((XMLStreamReader)this.xmlReader);
            String name = (String)attrs.get("name");
            String type = (String)attrs.get("type");
            Tuple.Two<String, Boolean> t = DataServiceUtils.getQueryType(type);
            query.addInput(name, (String)t.v1, (Boolean)t.v2);
        }
    }
}

