/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.parser;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.tools.data.Input;
import com.wavemaker.tools.data.QueryInfo;
import com.wavemaker.tools.data.parser.BaseHbmWriter;
import com.wavemaker.tools.data.util.DataServiceUtils;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbmQueryWriter
extends BaseHbmWriter {
    private String meta = null;
    private Collection<QueryInfo> queries = Collections.emptyList();

    public HbmQueryWriter(PrintWriter pw) {
        super(pw);
    }

    public void setQueries(Collection<QueryInfo> queries) {
        this.queries = queries;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    @Override
    public void writeCustom() {
        this.writeMeta();
        for (QueryInfo query : this.queries) {
            this.writeQuery(query);
        }
    }

    private void writeMeta() {
        if (this.meta == null) {
            return;
        }
        this.xmlWriter.addElement("meta", new String[]{"attribute", this.meta});
        this.xmlWriter.closeElement();
    }

    private void writeQuery(QueryInfo query) {
        this.xmlWriter.addElement("query");
        String comment = null;
        if (!ObjectUtils.isNullOrEmpty((String)query.getComment())) {
            comment = query.getComment();
        }
        if (query.getIsGenerated()) {
            if (comment != null) {
                this.xmlWriter.forceCloseOnNewLine();
            }
            comment = DataServiceUtils.addGeneratedAnnotation(comment, this.xmlWriter);
        }
        this.xmlWriter.addAttribute("name", query.getName());
        if (comment != null) {
            this.xmlWriter.addAttribute("comment", XMLUtils.escape((String)comment));
        }
        for (Input input : query.getInputs()) {
            String name = input.getParamName();
            String type = input.getParamType();
            if (input.getList().booleanValue()) {
                type = List.class.getName() + "<" + type + ">";
            }
            type = XMLUtils.escape((String)type);
            this.xmlWriter.addClosedElement("query-param", new String[]{"name", name, "type", type});
        }
        this.xmlWriter.addText(query.getQuery());
        this.xmlWriter.closeElement();
    }
}

