/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.parser;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.EntityInfo;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.parser.BaseHbmWriter;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbmWriter
extends BaseHbmWriter {
    private EntityInfo entity = null;

    public HbmWriter(PrintWriter pw) {
        super(pw);
    }

    public HbmWriter(File f) {
        super(f);
    }

    public void setEntity(EntityInfo entity) {
        this.entity = entity;
    }

    @Override
    public void writeCustom() {
        String schema;
        if (this.entity == null) {
            throw new IllegalArgumentException("entity must be set");
        }
        String className = StringUtils.fq((String)this.entity.getPackageName(), (String)this.entity.getEntityName());
        this.xmlWriter.addElement("class", new String[]{"name", className, "table", this.entity.getTableName()});
        String catalog = this.entity.getCatalogName();
        if (!ObjectUtils.isNullOrEmpty((String)catalog)) {
            this.xmlWriter.addAttribute("catalog", catalog);
        }
        if (!ObjectUtils.isNullOrEmpty((String)(schema = this.entity.getSchemaName()))) {
            this.xmlWriter.addAttribute("schema", schema);
        }
        this.xmlWriter.addAttribute("dynamic-insert", String.valueOf(this.entity.isDynamicInsert()));
        this.xmlWriter.addAttribute("dynamic-update", String.valueOf(this.entity.isDynamicUpdate()));
        HashSet<PropertyInfo> writtenProperties = new HashSet<PropertyInfo>();
        HashSet<String> mappedColumns = new HashSet<String>();
        PropertyInfo id = this.entity.getId();
        if (id != null) {
            this.writeProperty(id, writtenProperties, mappedColumns);
        }
        for (PropertyInfo property : this.entity.getProperties()) {
            if (property.getIsRelated()) continue;
            this.writeProperty(property, writtenProperties, mappedColumns);
        }
        for (PropertyInfo property : this.entity.getRelatedProperties()) {
            this.writeProperty(property, writtenProperties, mappedColumns);
        }
    }

    private void writeProperty(PropertyInfo property, Collection<PropertyInfo> writtenProperties, Collection<String> mappedColumns) {
        this.writeProperty(property, writtenProperties, mappedColumns, false);
    }

    private void writeProperty(PropertyInfo property, Collection<PropertyInfo> writtenProperties, Collection<String> mappedColumns, boolean isComposite) {
        if (writtenProperties.contains(property)) {
            return;
        }
        writtenProperties.add(property);
        if (property.getIsId()) {
            this.writeIdProperty(property, writtenProperties, mappedColumns, isComposite);
        } else if (property.getIsRelated()) {
            if (property.getIsInverse()) {
                this.writeToManyProperty(property, writtenProperties, mappedColumns);
            } else {
                this.writeToOneProperty(property, writtenProperties, mappedColumns);
            }
        } else if (property.hasCompositeProperties()) {
            this.writeComponent(property, writtenProperties, mappedColumns);
        } else {
            this.writeSimpleProperty(property, writtenProperties, mappedColumns);
        }
    }

    private void writeIdProperty(PropertyInfo property, Collection<PropertyInfo> writtenProperties, Collection<String> mappedColumns, boolean isComposite) {
        if (property.getCompositeProperties().isEmpty()) {
            Map<String, String> propertyAttrs = this.getPropertyAttributes(property);
            if (isComposite) {
                this.xmlWriter.addElement("key-property", propertyAttrs);
            } else {
                this.xmlWriter.addElement("id", propertyAttrs);
            }
            ColumnInfo column = property.getColumn();
            this.writeColumn(column, mappedColumns);
            String generator = column.getGenerator();
            if (!ObjectUtils.isNullOrEmpty((String)generator)) {
                this.xmlWriter.addElement("generator", new String[]{"class", generator});
                if (generator.equals("sequence") && !ObjectUtils.isNullOrEmpty((String)column.getGeneratorParam())) {
                    this.xmlWriter.addClosedTextElement("param", column.getGeneratorParam(), new String[]{"name", "sequence"});
                }
                this.xmlWriter.closeElement();
            }
            this.xmlWriter.closeElement();
        } else {
            Map<String, String> propertyAttrs = this.getPropertyAttributes(property, "class");
            this.xmlWriter.addElement("composite-id", propertyAttrs);
            for (PropertyInfo p : property.getCompositeProperties()) {
                this.writeProperty(p, writtenProperties, null, true);
            }
            this.xmlWriter.closeElement();
        }
    }

    private void writeColumn(ColumnInfo column, Collection<String> mappedColumns) {
        Map<String, String> attrs = this.getColumnAttributes(column);
        if (mappedColumns != null) {
            mappedColumns.add(attrs.get("name"));
        }
        this.xmlWriter.addElement("column", attrs);
        this.xmlWriter.closeElement();
    }

    private void writeToManyProperty(PropertyInfo property, Collection<PropertyInfo> writtenProperties, Collection<String> mappedColumns) {
        this.xmlWriter.addElement("set", new String[]{"name", property.getName(), "inverse", "true"});
        this.xmlWriter.addElement("key");
        for (ColumnInfo ci : property.allColumns()) {
            this.writeColumn(ci, mappedColumns);
        }
        this.xmlWriter.closeElement();
        this.xmlWriter.addClosedElement("one-to-many", new String[]{"class", property.getFullyQualifiedType()});
        this.xmlWriter.closeElement();
    }

    private void writeToOneProperty(PropertyInfo property, Collection<PropertyInfo> writtenProperties, Collection<String> mappedColumns) {
        Map<String, String> propertyAttrs = this.getPropertyAttributes(property, "class");
        boolean isReadOnly = false;
        PropertyInfo id = this.entity.getId();
        if (id != null) {
            HashSet<String> allIdColumnNames = new HashSet<String>(id.allColumnNames());
            boolean fkColIsPkCol = false;
            for (ColumnInfo ci : property.allColumns()) {
                if (!allIdColumnNames.contains(ci.getName())) continue;
                fkColIsPkCol = true;
                break;
            }
            if (fkColIsPkCol) {
                isReadOnly = true;
            }
        }
        if (isReadOnly) {
            this.insertUpdateFalse(propertyAttrs);
            propertyAttrs.put("fetch", "select");
        }
        if (!ObjectUtils.isNullOrEmpty(property.getCascadeOptions())) {
            propertyAttrs.put("cascade", ObjectUtils.toString(property.getCascadeOptions()));
        }
        this.xmlWriter.addElement("many-to-one", propertyAttrs);
        for (ColumnInfo ci : property.allColumns()) {
            this.writeColumn(ci, mappedColumns);
        }
        this.xmlWriter.closeElement();
    }

    private void insertUpdateFalse(Map<String, String> attrs) {
        attrs.put("update", "false");
        attrs.put("insert", "false");
    }

    private void writeComponent(PropertyInfo property, Collection<PropertyInfo> writtenProperties, Collection<String> mappedColumns) {
        Map<String, String> propertyAttrs = this.getPropertyAttributes(property, "class");
        this.xmlWriter.addElement("component", propertyAttrs);
        for (PropertyInfo p : property.getCompositeProperties()) {
            this.writeProperty(p, writtenProperties, mappedColumns, true);
        }
        this.xmlWriter.closeElement();
    }

    private void writeSimpleProperty(PropertyInfo property, Collection<PropertyInfo> writtenProperties, Collection<String> mappedColumns) {
        Map<String, String> propertyAttrs = this.getPropertyAttributes(property);
        if (mappedColumns.contains(property.getColumn().getName())) {
            this.insertUpdateFalse(propertyAttrs);
        }
        this.xmlWriter.addElement("property", propertyAttrs);
        this.writeColumn(property.getColumn(), mappedColumns);
        this.xmlWriter.closeElement();
    }

    private Map<String, String> getPropertyAttributes(PropertyInfo property) {
        return this.getPropertyAttributes(property, "type");
    }

    private Map<String, String> getPropertyAttributes(PropertyInfo property, String typeAttr) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("name", property.getName());
        if (!ObjectUtils.isNullOrEmpty((String)property.getFullyQualifiedType())) {
            attrs.put(typeAttr, property.getFullyQualifiedType());
        }
        return attrs;
    }

    private Map<String, String> getColumnAttributes(ColumnInfo column) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("name", column.getName());
        if (column.shouldPersistType() && !ObjectUtils.isNullOrEmpty((String)column.getSqlType())) {
            attrs.put("sql-type", column.getSqlType());
        }
        if (!this.isNullOrZero(column.getLength())) {
            attrs.put("length", String.valueOf(column.getLength()));
        }
        if (!this.isNullOrZero(column.getPrecision())) {
            attrs.put("precision", String.valueOf(column.getPrecision()));
        }
        if (!column.getIsPk() && column.getNotNull()) {
            attrs.put("not-null", String.valueOf(column.getNotNull()));
        }
        return attrs;
    }

    private boolean isNullOrZero(Integer i) {
        if (i == null) {
            return true;
        }
        return i.equals(0);
    }
}

