/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.reveng;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.tools.common.ConfigurationException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import org.hibernate.cfg.reveng.dialect.MySQLMetaDataDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMetaDataDialect
extends MySQLMetaDataDialect {
    public boolean needQuote(String name) {
        if (name == null) {
            return false;
        }
        boolean rtn = super.needQuote(name);
        if (rtn) {
            return true;
        }
        Collection<Character> charsNoQuote = this.getCharsNoQuote();
        for (int i = 0; i < name.length(); ++i) {
            Character c = Character.valueOf(name.charAt(i));
            if (c.equals(Character.valueOf('_'))) continue;
            if (c.equals(Character.valueOf('#')) || c.equals(Character.valueOf('@'))) {
                return true;
            }
            int type = Character.getType(name.charAt(i));
            if (type == 1 || type == 2 || type == 9 || charsNoQuote.contains(c)) continue;
            return true;
        }
        return false;
    }

    protected String getCatalogSeparator() {
        try {
            String rtn = this.getMetaData().getCatalogSeparator();
            if (ObjectUtils.isNullOrEmpty((String)rtn)) {
                rtn = ".";
            }
            return rtn;
        }
        catch (SQLException ex) {
            throw new ConfigurationException(ex);
        }
    }

    protected String getQuote() {
        try {
            return this.getMetaData().getIdentifierQuoteString().trim();
        }
        catch (SQLException ex) {
            throw new ConfigurationException(ex);
        }
    }

    protected String quote(String s) {
        String q = this.getQuote();
        if (!s.startsWith(q) && !s.endsWith(q)) {
            return q + s + q;
        }
        return s;
    }

    protected Collection<Character> getCharsNoQuote() {
        try {
            String s = this.getMetaData().getExtraNameCharacters();
            HashSet<Character> rtn = new HashSet<Character>(s.length());
            for (int i = 0; i < s.length(); ++i) {
                rtn.add(Character.valueOf(s.charAt(i)));
            }
            return rtn;
        }
        catch (SQLException ex) {
            throw new ConfigurationException(ex);
        }
    }
}

