/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.reveng;

import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.DataServiceLoggers;
import com.wavemaker.tools.data.reveng.BasicMetaDataDialect;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataDialect
extends BasicMetaDataDialect {
    public Iterator<Map<String, String>> getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        String pkStrategy = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            String sql = this.getSQL(catalog, schema, table);
            if (DataServiceLoggers.importLogger.isDebugEnabled()) {
                DataServiceLoggers.importLogger.debug((Object)("getSuggestedPrimaryKeyStrategyName: " + sql));
            }
            rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                if (!rsmd.isAutoIncrement(i)) continue;
                pkStrategy = "identity";
                break;
            }
        }
        catch (SQLException ex) {
            throw new ConfigurationException(ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ignore) {}
            try {
                stmt.close();
            }
            catch (Exception ignore) {}
        }
        HashMap<String, String> m = new HashMap<String, String>(4);
        m.put("TABLE_CAT", catalog);
        m.put("TABLE_SCHEMA", schema);
        m.put("TABLE_NAME", table);
        m.put("HIBERNATE_STRATEGY", pkStrategy);
        ArrayList<HashMap<String, String>> l = new ArrayList<HashMap<String, String>>(1);
        l.add(m);
        return l.iterator();
    }

    protected String getSQL(String catalog, String schema, String table) {
        String rtn = "select * from ";
        if (catalog != null) {
            rtn = rtn + this.quote(catalog) + this.getCatalogSeparator();
        }
        if (schema != null) {
            rtn = rtn + this.quote(schema) + this.getCatalogSeparator();
        }
        rtn = rtn + this.quote(table) + " where 1=0";
        return rtn;
    }
}

