/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.spring;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.data.DataServiceDefinition;
import com.wavemaker.runtime.data.DataServiceManager;
import com.wavemaker.runtime.data.util.QueryRunner;
import com.wavemaker.runtime.service.definition.DeprecatedServiceDefinition;
import com.wavemaker.tools.data.spring.SpringDataServiceManagerWrapper;
import com.wavemaker.tools.spring.SpringServiceDefinitionWrapper;
import java.io.File;
import java.util.Arrays;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;

public class SpringService {
    private SpringService() {
    }

    public static DeprecatedServiceDefinition initialize(File cfg) {
        return SpringService.initialize((org.springframework.core.io.Resource)new FileSystemResource(cfg));
    }

    public static DeprecatedServiceDefinition initialize(String cfg) {
        return SpringService.initialize((org.springframework.core.io.Resource)new ClassPathResource(cfg));
    }

    public static DeprecatedServiceDefinition initialize(org.springframework.core.io.Resource r) {
        return SpringService.getDataServiceDefinition(SpringService.initAppCtx(r));
    }

    public static QueryRunner initQueryRunner(File cfg) {
        return SpringService.initQueryRunner(SpringService.initAppCtx((org.springframework.core.io.Resource)new FileSystemResource(cfg)));
    }

    public static QueryRunner initQueryRunner(String cfg) {
        ClassPathResource r = new ClassPathResource(cfg);
        return SpringService.initQueryRunner(SpringService.initAppCtx((org.springframework.core.io.Resource)r));
    }

    private static QueryRunner initQueryRunner(GenericApplicationContext ctx) {
        return new QueryRunner(SpringService.getDataServiceManager(ctx));
    }

    private static DeprecatedServiceDefinition getDataServiceDefinition(GenericApplicationContext ctx) {
        DataServiceManager mgr = SpringService.getDataServiceManager(ctx);
        DataServiceDefinition def = new DataServiceDefinition(mgr.getMetaData());
        return new SpringServiceDefinitionWrapper(def, ctx);
    }

    private static DataServiceManager getDataServiceManager(GenericApplicationContext ctx) {
        DataServiceManager mgr = null;
        try {
            Object[] beanNames = ctx.getBeanNamesForType(DataServiceManager.class, true, false);
            if (null == beanNames || 1 != beanNames.length) {
                throw new WMRuntimeException(Resource.NO_DATA_SERVICE_MGR_BEAN_FOUND, new Object[]{Arrays.toString(beanNames)});
            }
            mgr = (DataServiceManager)ctx.getBean(beanNames[0]);
        }
        catch (RuntimeException ex) {
            try {
                ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        return new SpringDataServiceManagerWrapper(mgr, ctx);
    }

    private static GenericApplicationContext initAppCtx(org.springframework.core.io.Resource r) {
        ClassPathResource servicetypes = new ClassPathResource("servicetypes.xml");
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        xmlReader.setValidationMode(0);
        xmlReader.loadBeanDefinitions((org.springframework.core.io.Resource)servicetypes);
        xmlReader.loadBeanDefinitions(r);
        ctx.refresh();
        return ctx;
    }
}

