/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.upgrade;

import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;

public abstract class BaseDataUpgradeTask
implements UpgradeTask {
    private DesignServiceManager mgr = null;

    protected DesignServiceManager getDesignServiceManager() {
        if (this.mgr == null) {
            throw new IllegalStateException("mgr cannot be null");
        }
        return this.mgr;
    }

    protected File getCfgFile(String serviceId) {
        return new File(this.mgr.getServiceRuntimeDirectory(serviceId), DataServiceUtils.getCfgFileName(serviceId));
    }

    protected DataModelConfiguration getDataModelConfiguration(Service service) {
        return new DataModelConfiguration(this.getCfgFile(service.getId()));
    }

    protected abstract void upgrade(Service var1);

    protected String getUpgradeMsg() {
        return null;
    }

    public final void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        this.mgr = DesignTimeUtils.getDSMForProjectRoot(project.getProjectRoot());
        for (Service service : this.mgr.getServices()) {
            if (0 != "DataService".compareTo(service.getType())) continue;
            this.upgrade(service);
        }
        String msg = this.getUpgradeMsg();
        if (msg != null) {
            upgradeInfo.addVerbose(msg);
        }
    }
}

