/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.upgrade;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.data.DataServiceEventListener;
import com.wavemaker.runtime.data.QueryOptions;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.upgrade.BaseDataUpgradeTask;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.definitions.DataObject;
import com.wavemaker.tools.service.definitions.EventNotifier;
import com.wavemaker.tools.service.definitions.Operation;
import com.wavemaker.tools.service.definitions.Service;

public class DataServiceDefinitionUpgrade
extends BaseDataUpgradeTask
implements UpgradeTask {
    private static final String OLD_QUERY_OPTIONS = "com.activegrid.runtime.data.QueryOptions";
    private static final String OLD_EVENT_NOTIFIER = "com.activegrid.runtime.data.DataServiceEventListener";

    protected void upgrade(Service service) {
        boolean changed = this.upgradeQueryOptions(service);
        changed = this.upgradeEventNotifier(service) || changed;
        changed = this.setCRUDService(service) || changed;
        boolean bl = changed = this.addCRUDDataToTypes(service) || changed;
        if (changed) {
            this.getDesignServiceManager().saveServiceDefinition(service.getId());
        }
    }

    protected String getUpgradeMsg() {
        return "Upgraded data service definitions";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addCRUDDataToTypes(Service service) {
        DataModelConfiguration cfg = this.getDataModelConfiguration(service);
        try {
            for (DataObject o : service.getDataobjects().getDataobject()) {
                String name = (String)StringUtils.splitPackageAndClass((String)o.getJavaType()).v2;
                if (!cfg.isEntityType(name)) continue;
                o.setSupportsQuickData(Boolean.TRUE);
                for (DataObject.Element el : o.getElement()) {
                    PropertyInfo property = cfg.getProperty(name, el.getName());
                    this.setupDataConstraints(el, property);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            cfg.dispose();
        }
    }

    private boolean setCRUDService(Service service) {
        boolean changed = false;
        if (service.getCRUDService() != Boolean.TRUE) {
            service.setCRUDService(Boolean.TRUE);
            changed = true;
        }
        return changed;
    }

    private boolean upgradeQueryOptions(Service service) {
        boolean changed = false;
        for (Operation op : service.getOperation()) {
            for (Operation.Parameter p : op.getParameter()) {
                if (!p.getTypeRef().equals(OLD_QUERY_OPTIONS)) continue;
                p.setTypeRef(QueryOptions.class.getName());
                changed = true;
            }
        }
        return changed;
    }

    private boolean upgradeEventNotifier(Service service) {
        boolean changed = false;
        for (EventNotifier ev : service.getEventnotifier()) {
            if (!ev.getName().equals(OLD_EVENT_NOTIFIER)) continue;
            ev.setName(DataServiceEventListener.class.getName());
            changed = true;
        }
        return changed;
    }

    private void setupDataConstraints(DataObject.Element el, PropertyInfo p) {
        el.setAllowNull(DataServiceUtils.isAllowNull(p));
        el.getRequire().addAll(DataServiceUtils.getRequiredOperations(p));
        el.getNoChange().addAll(DataServiceUtils.getNoChangeOperations(p));
        el.getExclude().addAll(DataServiceUtils.getExcludedOperations(p));
    }
}

