/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.upgrade;

import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.EntityInfo;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.RelatedInfo;
import com.wavemaker.tools.data.upgrade.BaseDataUpgradeTask;
import com.wavemaker.tools.service.definitions.Service;
import java.util.List;

public class HibernateMappingUpgrade
extends BaseDataUpgradeTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgrade(Service service) {
        DataModelConfiguration cfg = this.getDataModelConfiguration(service);
        try {
            for (EntityInfo entity : cfg.getEntities()) {
                boolean modified = this.addSaveUpdate(entity);
                if (!modified) continue;
                cfg.touchEntity(entity);
            }
        }
        finally {
            cfg.dispose();
        }
        cfg.saveEntities();
    }

    protected String getUpgradeMsg() {
        return "Upgraded Hibernate mapping files";
    }

    private boolean addSaveUpdate(EntityInfo entity) {
        boolean modified = false;
        for (PropertyInfo property : entity.getProperties()) {
            if (!property.getIsRelated() || property.getIsInverse()) continue;
            List<RelatedInfo.CascadeOption> cascadeOptions = property.getCascadeOptions();
            boolean found = false;
            for (RelatedInfo.CascadeOption co : cascadeOptions) {
                if (co != RelatedInfo.CascadeOption.SaveUpdate) continue;
                found = true;
                break;
            }
            if (found) continue;
            cascadeOptions.add(RelatedInfo.CascadeOption.SaveUpdate);
            modified = true;
        }
        return modified;
    }
}

