/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.upgrade;

import com.wavemaker.runtime.data.DefaultTaskManager;
import com.wavemaker.runtime.data.spring.ConfigurationAndSessionFactoryBean;
import com.wavemaker.runtime.data.spring.SpringDataServiceManager;
import com.wavemaker.runtime.data.spring.WMPropertyPlaceholderConfigurer;
import com.wavemaker.tools.data.upgrade.BaseDataUpgradeTask;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.AbstractFileService;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.spring.beans.Bean;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.spring.beans.ConstructorArg;
import com.wavemaker.tools.spring.beans.Entry;
import com.wavemaker.tools.spring.beans.Map;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class SpringConfigurationUpgrade
extends BaseDataUpgradeTask
implements UpgradeTask {
    protected void upgrade(Service service) {
        this.upgradeSpringConfiguration(service);
    }

    protected String getUpgradeMsg() {
        return "Upgraded data service Spring files";
    }

    private void upgradeSpringConfiguration(Service service) {
        final String id = service.getId();
        final DesignServiceManager mgr = this.getDesignServiceManager();
        AbstractFileService fileService = new AbstractFileService(){

            public File getFileServiceRoot() {
                return mgr.getServiceHome(id);
            }
        };
        File cfgFile = this.getCfgFile(id);
        Beans beans = DataServiceUtils.readBeans(cfgFile, fileService);
        this.upgradePropertyPlaceholderConfigurer(beans);
        this.upgradeLocalSessionFactory(beans);
        this.upgradeSpringDataServiceManager(beans);
        this.upgradeTaskManager(beans);
        String path = cfgFile.getParentFile().getName() + "/" + cfgFile.getName();
        DataServiceUtils.writeBeans(beans, fileService, path);
    }

    private void upgradePropertyPlaceholderConfigurer(Beans beans) {
        List<Bean> ppcs = beans.getBeansByType(PropertyPlaceholderConfigurer.class.getName());
        for (Bean b : ppcs) {
            b.setClazz(WMPropertyPlaceholderConfigurer.class.getName());
        }
    }

    private void upgradeLocalSessionFactory(Beans beans) {
        List<Bean> ppcs = beans.getBeansByType("com.activegrid.runtime.data.spring.AGLocalSessionFactoryBean");
        for (Bean b : ppcs) {
            b.setClazz(ConfigurationAndSessionFactoryBean.class.getName());
        }
    }

    private void upgradeSpringDataServiceManager(Beans beans) {
        List<Bean> ppcs = beans.getBeansByType("com.activegrid.runtime.data.spring.SpringDataServiceManager");
        if (ppcs.isEmpty()) {
            boolean isAlphaProject = false;
            ppcs = beans.getBeansByType(SpringDataServiceManager.class.getName());
            for (Bean b : ppcs) {
                List<String> cl;
                ConstructorArg arg = new ConstructorArg();
                boolean useIndividualCRUDOps = false;
                if (b.getConstructorArgs().size() > 4 && (arg = b.getConstructorArgs().get(4)).getValueElement() != null && !(cl = arg.getValueElement().getContent()).isEmpty()) {
                    useIndividualCRUDOps = Boolean.valueOf(cl.get(0));
                    isAlphaProject = true;
                }
                if (!isAlphaProject) continue;
                b.getMetasAndConstructorArgsAndProperties().remove(arg);
                arg = new ConstructorArg();
                b.getMetasAndConstructorArgsAndProperties().add(arg);
                this.addGenerateCRUDOps(arg, useIndividualCRUDOps);
            }
        } else {
            for (Bean b : ppcs) {
                b.setClazz(SpringDataServiceManager.class.getName());
                ConstructorArg arg = new ConstructorArg();
                b.getMetasAndConstructorArgsAndProperties().add(arg);
                this.addGenerateCRUDOps(arg, true);
            }
        }
    }

    private void addGenerateCRUDOps(ConstructorArg arg, boolean value) {
        Map m = new Map();
        arg.setMap(m);
        Entry e = new Entry();
        m.getEntries().add(e);
        e.setKey("useIndividualCRUDOperations");
        e.setValue(String.valueOf(value));
    }

    private void upgradeTaskManager(Beans beans) {
        List<Bean> ppcs = beans.getBeansByType("com.activegrid.runtime.data.DefaultTaskManager");
        for (Bean b : ppcs) {
            b.setClazz(DefaultTaskManager.class.getName());
        }
    }
}

