/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data.util;

import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.common.util.XMLWriter;
import com.wavemaker.json.type.OperationEnumeration;
import com.wavemaker.runtime.data.DataServiceDefinition;
import com.wavemaker.runtime.data.DataServiceInternal;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.ExternalDataModelConfig;
import com.wavemaker.runtime.service.ElementType;
import com.wavemaker.runtime.service.definition.ServiceDefinition;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.BeanInfo;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.EntityInfo;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.RelatedInfo;
import com.wavemaker.tools.data.SpringCfgGenerator;
import com.wavemaker.tools.service.FileService;
import com.wavemaker.tools.service.codegen.GenerationUtils;
import com.wavemaker.tools.service.definitions.DataObject;
import com.wavemaker.tools.service.definitions.DataObjects;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.SpringServiceDefinitionWrapper;
import com.wavemaker.tools.spring.beans.Beans;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceUtils {
    private static final String CONSTANTS_CLASS_SUFFIX = "Constants";
    private static List<OperationEnumeration> NO_CHANGE_OPERATIONS = new ArrayList<OperationEnumeration>(3);
    private static List<OperationEnumeration> EXCLUDE_OPERATIONS;
    private static final Collection<String> QUERY_ANNOTATIONS;
    public static final DataModelConfiguration.UpdateCallback NOOP_UPDATE_CALLBACK;
    public static final Collection<String> RESERVED_WORDS;

    public static List<Class<?>> getTypesForGeneratedQueries(DataServiceMetaData metaData) {
        if (metaData.getEntityClasses().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList rtn = new ArrayList(1);
        for (Class<?> c : metaData.getEntityClasses()) {
            String idPropertyName;
            if (metaData.isCompositeProperty(c, idPropertyName = metaData.getIdPropertyName(c))) continue;
            rtn.add(c);
            return rtn;
        }
        rtn.add(metaData.getEntityClasses().iterator().next());
        return rtn;
    }

    public static String getCfgFileName(String serviceId) {
        return serviceId + ".spring.xml";
    }

    public static void setupElementTypeFactory(final DataModelConfiguration mgr, DataServiceInternal dataServiceDefinition) {
        dataServiceDefinition.setElementTypeFactory(new DataServiceInternal.ElementTypeFactory(){

            public ElementType getElementType(String javaType) {
                ElementType rtn = new ElementType(javaType);
                if (!mgr.isKnownType(javaType)) {
                    return rtn;
                }
                String s = mgr.getEntityName(javaType);
                if (mgr.isHelperType(javaType)) {
                    BeanInfo bi = mgr.getBean(s);
                    if (bi == null) {
                        throw new AssertionError((Object)("BeanInfo for " + s + " cannot be null"));
                    }
                    Map<String, String> props = bi.getProperties();
                    for (Map.Entry<String, String> e : props.entrySet()) {
                        String propName = e.getKey();
                        String propType = e.getValue();
                        boolean isList = false;
                        Tuple.Two<String, String> t = GenerationUtils.splitGenericType(propType);
                        if (t != null) {
                            propType = (String)t.v2;
                            isList = true;
                        }
                        ElementType el = new ElementType(propName, propType, isList);
                        rtn.addProperty(el);
                    }
                } else {
                    rtn.setSupportsQuickData(true);
                    EntityInfo ei = mgr.getEntity(s);
                    Collection<PropertyInfo> properties = mgr.getProperties(s);
                    for (PropertyInfo p : properties) {
                        ElementType el = new ElementType(p.getName(), DataServiceUtils.getJavaTypeName(p), DataServiceUtils.isList(p));
                        DataServiceUtils.configureElementType(p, el);
                        rtn.addProperty(el);
                        if (mgr.isValueType(el.getJavaType())) {
                            el.setTopLevel(true);
                        }
                        DataServiceUtils.addCompositeProperties(ei, p, el);
                    }
                }
                return rtn;
            }
        });
    }

    public static ServiceDefinition unwrap(ServiceDefinition def) {
        if (def instanceof SpringServiceDefinitionWrapper) {
            return ((SpringServiceDefinitionWrapper)def).unwrap();
        }
        return def;
    }

    public static DataServiceDefinition unwrapAndCast(ServiceDefinition def) {
        if (def instanceof SpringServiceDefinitionWrapper) {
            def = ((SpringServiceDefinitionWrapper)def).unwrap();
        }
        return (DataServiceDefinition)def;
    }

    public static String getDefaultPackage(String serviceName) {
        return "com." + serviceName;
    }

    public static String getDefaultDataPackage(String serviceName) {
        return StringUtils.fq((String)DataServiceUtils.getDefaultPackage(serviceName), (String)"data");
    }

    public static String removePrefix(Properties p) {
        String rtn = null;
        Iterator i$ = new HashSet(CastUtils.cast(p.keySet())).iterator();
        while (i$.hasNext()) {
            String key;
            String newKey = key = (String)i$.next();
            int i = key.indexOf(".");
            if (i > -1) {
                rtn = key.substring(0, i);
                newKey = key.substring(i + 1);
            }
            String value = (String)p.remove(key);
            p.setProperty(newKey, value);
        }
        if (ObjectUtils.isNullOrEmpty(rtn)) {
            rtn = null;
        }
        return rtn;
    }

    public static Properties addPrefix(String prefix, Properties p) {
        if (prefix == null) {
            return p;
        }
        Properties rtn = new Properties();
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        for (String key : new HashSet(CastUtils.cast(p.keySet()))) {
            String newKey = key;
            if (!newKey.startsWith(prefix)) {
                newKey = prefix + key;
            }
            rtn.setProperty(newKey, p.getProperty(key));
        }
        return rtn;
    }

    public static Properties readProperties(InputStream is) {
        return SystemUtils.loadPropertiesFromStream((InputStream)is);
    }

    public static void writeProperties(Properties p, File destdir, String serviceName) {
        File f = new File(destdir, serviceName + ".properties");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            DataServiceUtils.writeProperties(p, fos, serviceName);
        }
        catch (IOException ex) {
            throw new DataServiceRuntimeException(ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception ignore) {}
        }
    }

    public static void writeProperties(Properties p, OutputStream os, String serviceName) {
        String comment = DataServiceUtils.getPropertiesFileComment(serviceName);
        String key = serviceName + ".password";
        String pw = p.getProperty(key);
        if (pw != null && !SystemUtils.isEncrypted((String)pw)) {
            p.setProperty(key, SystemUtils.encrypt((String)pw));
        }
        SystemUtils.writePropertiesFile((OutputStream)os, (Properties)p, (String)comment);
    }

    public static String getPropertiesFileComment(String serviceName) {
        return "Properties for " + serviceName;
    }

    public static Properties addServiceName(Properties p, String serviceName) {
        String prefix = serviceName + ".";
        return DataServiceUtils.addPrefix(prefix, p);
    }

    public static File createEmptyDataModel(File destDir, String serviceId, String packageName) {
        return DataServiceUtils.createEmptyDataModel(destDir, serviceId, packageName, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createEmptyDataModel(File destDir, String serviceId, String packageName, String dataPackage) {
        File rtn = new File(destDir, DataServiceUtils.getCfgFileName(serviceId));
        SpringCfgGenerator g = new SpringCfgGenerator();
        try {
            g.setDestDir(rtn.getParentFile());
            g.setPackage(packageName);
            g.setDataPackage(dataPackage);
            g.setServiceName(serviceId);
            g.setDefaultDBType();
            g.run();
        }
        finally {
            g.dispose();
        }
        return rtn;
    }

    public static String sanitizeComment(String comment) {
        if (comment == null) {
            return null;
        }
        for (String anno : QUERY_ANNOTATIONS) {
            int i = comment.indexOf(anno);
            if (i <= -1) continue;
            String s = comment.substring(0, i);
            int j = i + anno.length();
            if (j == anno.length()) {
                comment = s;
                continue;
            }
            comment = s + comment.substring(j);
        }
        return comment.trim();
    }

    public static String getDefaultQueryFileName(Collection<String> reservedNames) {
        return StringUtils.getUniqueName((String)"app-queries.ql.xml", reservedNames);
    }

    public static boolean isDefaultQueryStore(String comment) {
        return DataServiceUtils.queryHasAnnotation(comment, "@design.default-queries");
    }

    public static boolean isGeneratedQuery(String comment) {
        return DataServiceUtils.queryHasAnnotation(comment, "@design.generated");
    }

    public static String addGeneratedAnnotation(String comment, XMLWriter writer) {
        return DataServiceUtils.addAnnotation(comment, "@design.generated", writer);
    }

    public static Service toService(Collection<EntityInfo> entities) {
        Service rtn = new Service();
        rtn.setDataobjects(new DataObjects());
        for (EntityInfo ei : entities) {
            String javaType = StringUtils.fq((String)ei.getPackageName(), (String)ei.getEntityName());
            ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
            if (ei.getId() == null) {
                throw new AssertionError((Object)"id property cannot be null");
            }
            properties.add(ei.getId());
            properties.addAll(ei.getProperties());
            DataServiceUtils.addTypeToService(javaType, rtn, properties);
        }
        return rtn;
    }

    public static Collection<String> getServiceClassNames(String packageName, String serviceName) {
        HashSet<String> rtn = new HashSet<String>(2);
        String serviceClassName = StringUtils.fq((String)packageName, (String)DataServiceUtils.getServiceClassName(serviceName));
        rtn.add(serviceClassName);
        rtn.add(DataServiceUtils.getConstantsClassName(serviceClassName));
        return rtn;
    }

    public static ExternalDataModelConfig getDummyExternalConfig() {
        return new ExternalDataModelConfig(){

            public boolean returnsSingleResult(String operationName) {
                return false;
            }

            public String getOutputType(String operationName) {
                return null;
            }

            public String getServiceClass() {
                return "";
            }
        };
    }

    public static Beans readBeans(FileService fileService, String path) {
        String springConfig = null;
        try {
            springConfig = fileService.readFile(path);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        try {
            return SpringConfigSupport.readBeans(springConfig);
        }
        catch (JAXBException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public static Beans readBeans(File springConfig, FileService fileService) {
        try {
            return SpringConfigSupport.readBeans(springConfig, fileService);
        }
        catch (JAXBException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public static void writeBeans(Beans beans, FileService fileService, String path) {
        Writer writer = null;
        try {
            writer = fileService.getWriter(path);
            SpringConfigSupport.writeBeans(beans, writer);
            writer.close();
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        catch (JAXBException ex) {
            throw new ConfigurationException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ignore) {}
        }
    }

    public static boolean isAllowNull(PropertyInfo p) {
        if (p.getIsInverse()) {
            return true;
        }
        ColumnInfo ci = p.getColumn();
        if (ci != null) {
            return !ci.getNotNull();
        }
        return false;
    }

    public static List<OperationEnumeration> getExcludedOperations(PropertyInfo p) {
        ColumnInfo ci = p.getColumn();
        if (p.getIsId() && ci != null && ci.generated()) {
            return EXCLUDE_OPERATIONS;
        }
        return Collections.emptyList();
    }

    public static List<OperationEnumeration> getNoChangeOperations(PropertyInfo p) {
        if (p.getIsId()) {
            return NO_CHANGE_OPERATIONS;
        }
        return Collections.emptyList();
    }

    public static List<OperationEnumeration> getRequiredOperations(PropertyInfo p) {
        ArrayList<OperationEnumeration> rtn = new ArrayList<OperationEnumeration>();
        ColumnInfo ci = p.getColumn();
        if (p.getIsId()) {
            rtn.add(OperationEnumeration.delete);
            rtn.add(OperationEnumeration.read);
            rtn.add(OperationEnumeration.update);
            if (ci == null) {
                rtn.add(OperationEnumeration.insert);
            } else if (!ci.generated()) {
                rtn.add(OperationEnumeration.insert);
            }
        }
        return rtn;
    }

    public static String getServiceClassName(String serviceName) {
        return StringUtils.upperCaseFirstLetter((String)serviceName);
    }

    public static String getConstantsClassName(String serviceClassName) {
        return serviceClassName + CONSTANTS_CLASS_SUFFIX;
    }

    private static void addTypeToService(String javaType, Service service, Collection<PropertyInfo> properties) {
        DataObject o = new DataObject();
        service.getDataobjects().getDataobject().add(o);
        o.setJavaType(javaType);
        o.setName((String)StringUtils.splitPackageAndClass((String)javaType).v2);
        HashSet<PropertyInfo> added = new HashSet<PropertyInfo>();
        for (PropertyInfo pi : properties) {
            if (added.contains(pi)) continue;
            DataServiceUtils.addProperty(pi, o);
            added.add(pi);
            if (pi.getIsRelated() || !pi.hasCompositeProperties()) continue;
            DataServiceUtils.addTypeToService(pi.getFullyQualifiedType(), service, pi.getCompositeProperties());
        }
    }

    private static void addProperty(PropertyInfo pi, DataObject o) {
        DataObject.Element e = new DataObject.Element();
        o.getElement().add(e);
        e.setName(pi.getName());
        e.setTypeRef(pi.javaType());
        e.setIsList(pi.getIsInverse());
    }

    private static boolean queryHasAnnotation(String comment, String anno) {
        return DataServiceUtils.getAnnotation(comment, anno) != null;
    }

    private static String getAnnotation(String comment, String anno) {
        if (comment == null) {
            return null;
        }
        int i = comment.indexOf(anno);
        if (i == -1) {
            return null;
        }
        int j = comment.indexOf("@", i + 1);
        if (j == -1) {
            j = comment.length();
        }
        return comment.substring(i + anno.length(), j).trim();
    }

    private static String addAnnotation(String comment, String anno, XMLWriter writer) {
        if (comment == null) {
            comment = "";
        }
        String sep = writer.willCloseOnNewLine() ? writer.getLineSep() : "";
        StringBuilder sb = new StringBuilder();
        if (writer.willCloseOnNewLine()) {
            sb.append(writer.getIndent());
            for (int i = 0; i < "comment".length() + 2; ++i) {
                sb.append(" ");
            }
        }
        return comment + sep + sb.toString() + anno;
    }

    private static boolean isList(PropertyInfo p) {
        return p.getCardinality() != null && p.getCardinality() == RelatedInfo.Cardinality.OneToMany;
    }

    private static String getJavaTypeName(PropertyInfo p) {
        return p.javaType();
    }

    private static void configureElementType(PropertyInfo p, ElementType el) {
        el.setAllowNull(DataServiceUtils.isAllowNull(p));
        el.setNoChange(DataServiceUtils.getNoChangeOperations(p));
        el.setRequire(DataServiceUtils.getRequiredOperations(p));
        el.setExclude(DataServiceUtils.getExcludedOperations(p));
    }

    private static void addCompositeProperties(EntityInfo ei, PropertyInfo p, ElementType el) {
        if (p.getCompositeProperties() == null) {
            return;
        }
        for (PropertyInfo p2 : p.getCompositeProperties()) {
            ElementType el2 = new ElementType(p2.getName(), DataServiceUtils.getJavaTypeName(p2), DataServiceUtils.isList(p2));
            DataServiceUtils.configureElementType(p2, el2);
            el.addProperty(el2);
            DataServiceUtils.addCompositeProperties(ei, p2, el2);
        }
    }

    private DataServiceUtils() {
        throw new UnsupportedOperationException();
    }

    static {
        NO_CHANGE_OPERATIONS.add(OperationEnumeration.delete);
        NO_CHANGE_OPERATIONS.add(OperationEnumeration.read);
        NO_CHANGE_OPERATIONS.add(OperationEnumeration.update);
        EXCLUDE_OPERATIONS = new ArrayList<OperationEnumeration>(1);
        EXCLUDE_OPERATIONS.add(OperationEnumeration.insert);
        QUERY_ANNOTATIONS = new HashSet<String>(1);
        QUERY_ANNOTATIONS.add("@design.generated");
        NOOP_UPDATE_CALLBACK = new DataModelConfiguration.UpdateCallback(){

            public void update(DataServiceDefinition dataServiceDefinition) {
            }
        };
        RESERVED_WORDS = new HashSet<String>(1);
        RESERVED_WORDS.add("data");
    }
}

