/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.deployment;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.DataModelDeploymentConfiguration;
import com.wavemaker.tools.deployment.ServiceDeployment;
import com.wavemaker.tools.deployment.xmlhandlers.Targets;
import com.wavemaker.tools.project.DeploymentManager;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.project.StudioConfiguration;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDeploymentManager {
    private List<ServiceDeployment> serviceDeployments = new ArrayList<ServiceDeployment>(1);
    private StudioConfiguration studioConfiguration = null;
    private ProjectManager projectMgr = null;

    public ServiceDeploymentManager() {
        this.serviceDeployments.add(new DataModelDeploymentConfiguration());
    }

    public File generateWebapp(Map<String, String> properties) {
        return this.generateWebapp(this.getProjectRoot(), properties);
    }

    public File generateWebapp(File projectRoot, Map<String, String> properties) {
        File stagingProjectDir = null;
        try {
            stagingProjectDir = IOUtils.createTempDirectory((String)"dplstaging", (String)"dir");
            IOUtils.copy((File)projectRoot, (File)stagingProjectDir);
            DesignServiceManager mgr = DesignTimeUtils.getDSMForProjectRoot(stagingProjectDir);
            this.prepareForDeployment(mgr, properties);
            File file = this.buildWar(mgr.getProjectManager(), this.getWarFile());
            return file;
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        finally {
            try {
                IOUtils.deleteRecursive((File)stagingProjectDir);
            }
            catch (Exception ignore) {}
        }
    }

    public File getWarFile() {
        String acctInfo;
        File projectRoot = this.getProjectRoot();
        File destDir = new File(projectRoot, "dist");
        String warFileName = projectRoot.getName();
        if (warFileName.contains(acctInfo = this.projectMgr.getUserProjectPrefix())) {
            int len = acctInfo.length();
            warFileName = warFileName.substring(len);
        }
        return new File(destDir, warFileName + ".war");
    }

    public File getEarFile() {
        String acctInfo;
        File projectRoot = this.getProjectRoot();
        File destDir = new File(projectRoot, "dist");
        String earFileName = projectRoot.getName();
        if (earFileName.contains(acctInfo = this.projectMgr.getUserProjectPrefix())) {
            int len = acctInfo.length();
            earFileName = earFileName.substring(len);
        }
        return new File(destDir, earFileName + ".ear");
    }

    public void setServiceDeployments(List<ServiceDeployment> serviceDeployments) {
        this.serviceDeployments = serviceDeployments;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public void setProjectManager(ProjectManager projectMgr) {
        this.projectMgr = projectMgr;
    }

    public ProjectManager getProjectManager() {
        return this.projectMgr;
    }

    public Map<String, Targets.Target> getDeploymentTargetList() {
        File file = new File(StudioConfiguration.staticGetWaveMakerHome().getAbsolutePath(), "deploymentTargets.xml");
        HashMap<String, Targets.Target> rtn = new HashMap<String, Targets.Target>();
        try {
            FileInputStream inputStream = new FileInputStream(file);
            JAXBContext respContext = JAXBContext.newInstance((Class[])new Class[]{Targets.class});
            Unmarshaller unmarshaller = respContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)inputStream);
            Targets targets = (Targets)Targets.class.cast(object);
            List<Targets.Target> tlist = targets.getTarget();
            for (Targets.Target target : tlist) {
                String key = target.getName();
                rtn.put(key, target);
            }
            inputStream.close();
        }
        catch (Exception e) {
            throw new WMRuntimeException((Throwable)e);
        }
        return rtn;
    }

    public Targets.Target getDeploymentTarget(String targetName) {
        Map<String, Targets.Target> targets = this.getDeploymentTargetList();
        return targets.get(targetName);
    }

    public String updateDeploymentTarget(Targets.Target newTarget, boolean override) {
        File file = new File(StudioConfiguration.staticGetWaveMakerHome().getAbsolutePath(), "deploymentTargets.xml");
        boolean exists = false;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            JAXBContext respContext = JAXBContext.newInstance((Class[])new Class[]{Targets.class});
            Unmarshaller unmarshaller = respContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)inputStream);
            Targets targets = (Targets)Targets.class.cast(object);
            List<Targets.Target> tlist = targets.getTarget();
            inputStream.close();
            Targets.Target targetFound = null;
            for (Targets.Target target : tlist) {
                String key = target.getName();
                if (!newTarget.getName().equals(key)) continue;
                exists = true;
                targetFound = target;
                break;
            }
            if (exists) {
                if (!override) {
                    return "WARNING: Deployment target " + newTarget.getName() + " already exists. No update is done.";
                }
                targetFound.setName(newTarget.getName());
                targetFound.setDescription(newTarget.getDescription());
                targetFound.setDestType(newTarget.getDestType());
                targetFound.setServiceProvider(newTarget.getServiceProvider());
                targetFound.setServer(newTarget.getServer());
                targetFound.setContainer(newTarget.getContainer());
                targetFound.setDnsHost(newTarget.getDnsHost());
                targetFound.setPublicIp(newTarget.getPublicIp());
                targetFound.setPrivateIp(newTarget.getPrivateIp());
                targetFound.setPort(newTarget.getPort());
                targetFound.setUser(newTarget.getUser());
                targetFound.setPassword(newTarget.getPassword());
            } else {
                tlist.add(newTarget);
            }
            Marshaller marshaller = respContext.createMarshaller();
            FileOutputStream outputStream = new FileOutputStream(file);
            marshaller.marshal((Object)targets, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            throw new WMRuntimeException((Throwable)e);
        }
        String msg = "";
        msg = exists ? "Deployment target " + newTarget.getName() + " has been successfully updated." : "New deployment target " + newTarget.getName() + " has been successfully added.";
        return msg;
    }

    public void deleteDeploymentTarget(String targetName) {
        File file = new File(StudioConfiguration.staticGetWaveMakerHome().getAbsolutePath(), "deploymentTargets.xml");
        boolean deleted = false;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            JAXBContext respContext = JAXBContext.newInstance((Class[])new Class[]{Targets.class});
            Unmarshaller unmarshaller = respContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)inputStream);
            Targets targets = (Targets)Targets.class.cast(object);
            List<Targets.Target> tlist = targets.getTarget();
            inputStream.close();
            Object targetFound = null;
            for (Targets.Target target : tlist) {
                String key = target.getName();
                if (!targetName.equals(key)) continue;
                tlist.remove(target);
                deleted = true;
                break;
            }
            if (deleted) {
                Marshaller marshaller = respContext.createMarshaller();
                FileOutputStream outputStream = new FileOutputStream(file);
                marshaller.marshal((Object)targets, (OutputStream)outputStream);
                outputStream.close();
            }
        }
        catch (Exception e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    private File getProjectRoot() {
        return this.projectMgr.getCurrentProject().getProjectRoot();
    }

    private File buildWar(ProjectManager projectMgr, File warFile) throws IOException {
        DeploymentManager deploymentMgr = new DeploymentManager();
        deploymentMgr.setProjectManager(projectMgr);
        deploymentMgr.setStudioConfiguration(this.studioConfiguration);
        String war = deploymentMgr.buildWar(warFile);
        return new File(war);
    }

    private void prepareForDeployment(DesignServiceManager mgr, Map<String, String> properties) {
        for (Service service : mgr.getServices()) {
            if (!service.getType().equals("DataService")) continue;
            this.storeProperties(properties);
            Map<String, String> m = this.getServiceProperties(properties, service.getId());
            for (ServiceDeployment sd : this.serviceDeployments) {
                sd.prepare(service.getId(), m, mgr);
            }
        }
    }

    private void storeProperties(Map<String, String> properties) {
        Project p = this.projectMgr.getCurrentProject();
        p.clearProperties(ServiceDeploymentManager.class);
        for (Map.Entry<String, String> e : properties.entrySet()) {
            p.setProperty(ServiceDeploymentManager.class, e.getKey(), e.getValue());
        }
    }

    private Map<String, String> getServiceProperties(Map<String, String> properties, String serviceName) {
        HashMap<String, String> rtn = new HashMap<String, String>();
        String s = serviceName + ".";
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (!e.getKey().startsWith(s)) continue;
            rtn.put(e.getKey().substring(s.length()), e.getValue());
        }
        return rtn;
    }
}

