/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.deployment.tomcat;

import com.wavemaker.common.util.Tuple;
import com.wavemaker.tools.deployment.AppInfo;
import com.wavemaker.tools.deployment.DeploymentTarget;
import com.wavemaker.tools.util.TomcatServer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDeploymentTarget
implements DeploymentTarget {
    protected static final String HOST_PROPERTY_NAME = "host";
    protected static final String PORT_PROPERTY_NAME = "port";
    protected static final String MANAGER_USER_PROPERTY_NAME = "username";
    protected static final String MANAGER_PASSWORD_PROPERTY_NAME = "password";
    protected static final Map<String, String> CONFIGURABLE_PROPERTIES;

    @Override
    public String deploy(File f, String contextRoot, Map<String, String> props) {
        TomcatServer tomcat = this.initTomcat(props);
        return tomcat.deploy(f, contextRoot);
    }

    @Override
    public String undeploy(String contextRoot, Map<String, String> props) {
        TomcatServer tomcat = this.initTomcat(props);
        return tomcat.undeploy(contextRoot);
    }

    @Override
    public String redeploy(String contextRoot, Map<String, String> props) {
        TomcatServer tomcat = this.initTomcat(props);
        return tomcat.redeploy(contextRoot);
    }

    @Override
    public List<AppInfo> listDeploymentNames(Map<String, String> props) {
        TomcatServer tomcat = this.initTomcat(props);
        List<Tuple.Two<String, String>> apps = tomcat.listDeployments();
        ArrayList<AppInfo> rtn = new ArrayList<AppInfo>(apps.size());
        for (Tuple.Two<String, String> t : apps) {
            StringBuilder url = new StringBuilder();
            url.append("http://").append(this.getHostName(props)).append(":").append(this.getPort(props)).append((String)t.v1);
            StringBuilder href = new StringBuilder();
            href.append("<a href=\"").append((CharSequence)url).append("\" target=\"_blank\">").append((CharSequence)url).append("</a>");
            rtn.add(new AppInfo((String)t.v1, href.toString(), (String)t.v2));
        }
        Collections.sort(rtn);
        return rtn;
    }

    @Override
    public Map<String, String> getConfigurableProperties() {
        return CONFIGURABLE_PROPERTIES;
    }

    private String getHostName(Map<String, String> props) {
        return props.get(HOST_PROPERTY_NAME);
    }

    private int getPort(Map<String, String> props) {
        return Integer.parseInt(props.get(PORT_PROPERTY_NAME));
    }

    private String getUsername(Map<String, String> props) {
        return props.get(MANAGER_USER_PROPERTY_NAME);
    }

    private String getPassword(Map<String, String> props) {
        return props.get(MANAGER_PASSWORD_PROPERTY_NAME);
    }

    private TomcatServer initTomcat(Map<String, String> props) {
        TomcatServer rtn = new TomcatServer();
        rtn.setHost(this.getHostName(props));
        rtn.setPort(this.getPort(props));
        rtn.setUsername(this.getUsername(props));
        rtn.setPassword(this.getPassword(props));
        return rtn;
    }

    static {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(4);
        m.put(HOST_PROPERTY_NAME, "localhost");
        m.put(PORT_PROPERTY_NAME, "8080");
        m.put(MANAGER_USER_PROPERTY_NAME, "manager");
        m.put(MANAGER_PASSWORD_PROPERTY_NAME, "manager");
        CONFIGURABLE_PROPERTIES = Collections.unmodifiableMap(m);
    }
}

