/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.deployment.websphere;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.tools.deployment.AppInfo;
import com.wavemaker.tools.deployment.DeploymentTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSphereDeploymentTarget
implements DeploymentTarget {
    protected static final String HOST_PROPERTY_NAME = "host";
    protected static final String PORT_PROPERTY_NAME = "port";
    protected static final String MANAGER_USER_PROPERTY_NAME = "username";
    protected static final String MANAGER_PASSWORD_PROPERTY_NAME = "password";
    protected static final Map<String, String> CONFIGURABLE_PROPERTIES;
    private List<AppInfo> appInfoList;
    private String DEPLOYMENT_COMMAND = org.apache.commons.lang.SystemUtils.IS_OS_WINDOWS ? "Deployment.bat" : "Deployment.sh";

    @Override
    public Map<String, String> getConfigurableProperties() {
        return CONFIGURABLE_PROPERTIES;
    }

    public Map<String, String> getConfigurableProperties(String hostName) {
        Map<String, String> m = this.getConfigurableProperties();
        HashMap<String, String> hm = new HashMap<String, String>(m);
        hm.put(HOST_PROPERTY_NAME, hostName);
        return hm;
    }

    @Override
    public String deploy(File f, String contextRoot, Map<String, String> props) {
        String host = props.get(HOST_PROPERTY_NAME);
        String port = props.get(PORT_PROPERTY_NAME);
        String userId = props.get(MANAGER_USER_PROPERTY_NAME);
        String passwd = props.get(MANAGER_PASSWORD_PROPERTY_NAME);
        String earFileName = f.getAbsolutePath();
        String appName = this.extractAppName(f);
        String cmd = SystemUtils.getWavemakerRoot() + "/" + "websphere" + "/bin" + "/" + this.DEPLOYMENT_COMMAND + " deploy " + appName + " " + earFileName + " " + host + " " + port + " " + userId + " " + passwd;
        System.out.println("\ncommand = " + cmd + "\n");
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "[StdErr]");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "[StdOut]");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            System.out.println("Exit Value = " + exitVal);
            if (exitVal != 0) {
                throw new WMRuntimeException("Deploy to WebSphere failed.  The exit value is " + exitVal + ".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WMRuntimeException((Throwable)e);
        }
        return "";
    }

    @Override
    public String undeploy(String contextRoot, Map<String, String> props) {
        String host = props.get(HOST_PROPERTY_NAME);
        String port = props.get(PORT_PROPERTY_NAME);
        String userId = props.get(MANAGER_USER_PROPERTY_NAME);
        String passwd = props.get(MANAGER_PASSWORD_PROPERTY_NAME);
        String earFileName = "dummy";
        String appName = contextRoot.substring(1);
        String cmd = SystemUtils.getWavemakerRoot() + "/" + "websphere" + "/bin" + "/" + this.DEPLOYMENT_COMMAND + " undeploy " + appName + " " + earFileName + " " + host + " " + port + " " + userId + " " + passwd;
        System.out.println("\ncommand = " + cmd + "\n");
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "[StdErr]");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "[StdOut]");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            System.out.println("Exit Value = " + exitVal);
            if (exitVal != 0) {
                throw new WMRuntimeException("Undeploy from WebSphere failed.  The exit value is " + exitVal + ".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WMRuntimeException((Throwable)e);
        }
        return "";
    }

    @Override
    public List<AppInfo> listDeploymentNames(Map<String, String> props) {
        String host = props.get(HOST_PROPERTY_NAME);
        String port = props.get(PORT_PROPERTY_NAME);
        String userId = props.get(MANAGER_USER_PROPERTY_NAME);
        String passwd = props.get(MANAGER_PASSWORD_PROPERTY_NAME);
        String earFileName = "dummy";
        String appName = "dummy";
        String cmd = SystemUtils.getWavemakerRoot() + "/" + "websphere" + "/bin" + "/" + this.DEPLOYMENT_COMMAND + " list " + appName + " " + earFileName + " " + host + " " + port + " " + userId + " " + passwd;
        System.out.println("\ncommand = " + cmd + "\n");
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "[StdErr]");
            StreamGobblerForList outputGobbler = new StreamGobblerForList(proc.getInputStream(), "[StdOut]");
            errorGobbler.start();
            outputGobbler.start();
            int exitVal = proc.waitFor();
            System.out.println("Exit Value = " + exitVal);
            if (exitVal != 0) {
                throw new WMRuntimeException("Accessing WebSphere failed.  The exit value is " + exitVal + ".");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WMRuntimeException((Throwable)e);
        }
        return this.appInfoList;
    }

    @Override
    public String redeploy(String contextRoot, Map<String, String> configuredProperties) {
        return null;
    }

    private String extractAppName(File earFile) {
        String fileName = earFile.getName();
        return fileName.substring(0, fileName.length() - 4);
    }

    static {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>(4);
        m.put(HOST_PROPERTY_NAME, "localhost");
        m.put(PORT_PROPERTY_NAME, "8880");
        m.put(MANAGER_USER_PROPERTY_NAME, "virtuser");
        m.put(MANAGER_PASSWORD_PROPERTY_NAME, "chris1keene");
        CONFIGURABLE_PROPERTIES = Collections.unmodifiableMap(m);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StreamGobblerForList
    extends Thread {
        InputStream is;
        String type;

        StreamGobblerForList(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        @Override
        public void run() {
            try {
                String line;
                StringBuilder sb = new StringBuilder();
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    System.out.println(this.type + " " + line);
                }
                WebSphereDeploymentTarget.this.appInfoList = this.buildAppInfoList(sb);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private List<AppInfo> buildAppInfoList(StringBuilder sb) {
            String startstr = "--- start of module list ---";
            String endstr = "--- end of module list ---";
            int indx1 = sb.indexOf(startstr);
            int indx2 = sb.indexOf(endstr);
            String str = sb.substring(indx1 + startstr.length(), indx2 - 1);
            String[] lines = str.split("\\$");
            ArrayList<AppInfo> rtn = new ArrayList<AppInfo>(lines.length);
            for (String line : lines) {
                String[] props = line.split("\\|");
                StringBuilder url = new StringBuilder();
                url.append("http://").append(props[1]).append(":").append("9080").append("/").append(props[0]);
                StringBuilder href = new StringBuilder();
                href.append("<a href=\"").append((CharSequence)url).append("\" target=\"_blank\">").append((CharSequence)url).append("</a>");
                rtn.add(new AppInfo("/" + props[0], href.toString(), props[2]));
            }
            return rtn;
        }
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + " " + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

