/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.javaservice;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.json.type.FieldDefinition;
import com.wavemaker.json.type.PrimitiveTypeDefinition;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.json.type.TypeState;
import com.wavemaker.json.type.reflect.ReflectTypeDefinition;
import com.wavemaker.json.type.reflect.ReflectTypeState;
import com.wavemaker.json.type.reflect.ReflectTypeUtils;
import com.wavemaker.runtime.javaservice.JavaServiceType;
import com.wavemaker.runtime.server.ServerUtils;
import com.wavemaker.runtime.service.LiveDataService;
import com.wavemaker.runtime.service.ServiceType;
import com.wavemaker.runtime.service.definition.ReflectServiceDefinition;
import com.wavemaker.runtime.service.definition.ServiceOperation;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaServiceDefinition
implements ReflectServiceDefinition {
    private final String serviceId;
    private List<TypeDefinition> typeDefinitions = null;
    private List<ServiceOperation> operations = null;
    private final List<String> excludeTypeNames;
    private boolean implementsCRUDService = false;
    private String packageName = null;
    private String serviceClassName = null;

    public JavaServiceDefinition() {
        this.serviceId = "";
        this.excludeTypeNames = null;
    }

    public JavaServiceDefinition(String serviceClassName, String serviceId, File serviceCompiledDir, File serviceLibDir, List<String> excludeTypeNames) throws ClassNotFoundException, LinkageError {
        this(serviceClassName, serviceId, null == serviceCompiledDir ? null : Arrays.asList(serviceCompiledDir), null == serviceLibDir ? null : Arrays.asList(serviceLibDir), excludeTypeNames);
    }

    public JavaServiceDefinition(String serviceClassName, String serviceId, List<File> serviceCompiledDirs, List<File> serviceLibDirs, List<String> excludeTypeNames) throws ClassNotFoundException, LinkageError {
        ArrayList<File> classpath = new ArrayList<File>();
        if (null != serviceCompiledDirs) {
            classpath.addAll(serviceCompiledDirs);
        }
        if (null != serviceLibDirs) {
            for (File serviceLibDir : serviceLibDirs) {
                if (!serviceLibDir.exists()) continue;
                if (!serviceLibDir.isDirectory()) {
                    throw new WMRuntimeException(Resource.LIB_DIR_NOT_DIR, new Object[]{serviceLibDir});
                }
                classpath.addAll(FileUtils.listFiles((File)serviceLibDir, (String[])new String[]{"jar"}, (boolean)false));
            }
        }
        ClassLoader cl = ClassLoaderUtils.getTempClassLoaderForFile((File[])classpath.toArray(new File[0]));
        Class serviceClass = ClassLoaderUtils.loadClass((String)serviceClassName, (boolean)false, (ClassLoader)cl);
        Class runtimeServiceClass = ClassLoaderUtils.loadClass((String)"com.wavemaker.runtime.service.LiveDataService", (ClassLoader)cl);
        this.serviceId = serviceId;
        this.excludeTypeNames = excludeTypeNames;
        this.init(serviceClass, runtimeServiceClass);
    }

    public JavaServiceDefinition(Class<?> serviceClass, String serviceId) {
        this.serviceId = serviceId;
        this.excludeTypeNames = new ArrayList<String>();
        this.init(serviceClass, LiveDataService.class);
    }

    public static String getFQClassFromFile(File javaFile, File srcRoot) {
        String fqClass = javaFile.getAbsolutePath().replace(srcRoot.getAbsolutePath(), "");
        fqClass = fqClass.replaceAll("^[/\\\\]", "");
        fqClass = fqClass.replaceAll("\\.java$", "");
        fqClass = fqClass.replace('/', '.');
        fqClass = fqClass.replace('\\', '.');
        return fqClass;
    }

    public static String getRelPathFromClass(String fqClassName) {
        return fqClassName.replace('.', '/') + ".java";
    }

    public static String getClass(String fqClassName) {
        String ret = fqClassName.contains(".") ? fqClassName.substring(fqClassName.lastIndexOf(46) + 1) : fqClassName;
        return ret;
    }

    public static String getPackage(String fqClassName) {
        String ret = null;
        if (fqClassName.contains(".")) {
            ret = fqClassName.substring(0, fqClassName.lastIndexOf(46));
        }
        return ret;
    }

    private void init(Class<?> serviceClass, Class<?> runtimeServiceClass) {
        this.operations = new ArrayList<ServiceOperation>();
        this.typeDefinitions = new ArrayList<TypeDefinition>();
        ReflectTypeState typeState = new ReflectTypeState();
        Collection<Method> methods = JavaServiceDefinition.filterOverloadedMethods(ServerUtils.getClientExposedMethods(serviceClass));
        for (Method m : methods) {
            this.initOperation(m, (TypeState)typeState);
        }
        this.implementsCRUDService = runtimeServiceClass.isAssignableFrom(serviceClass);
        this.serviceClassName = serviceClass.getName();
        if (this.implementsCRUDService) {
            for (TypeDefinition td : this.typeDefinitions) {
                ((ReflectTypeDefinition)td).setLiveService(this.implementsCRUDService);
            }
        }
        this.packageName = null == serviceClass.getPackage() ? null : serviceClass.getPackage().getName();
    }

    private void initOperation(Method method, TypeState typeState) {
        ServiceOperation so = new ServiceOperation();
        so.setName(method.getName());
        if (!method.getReturnType().equals(Void.TYPE)) {
            so.setReturnType(ReflectTypeUtils.getFieldDefinition((Method)method, (TypeState)typeState, (boolean)false, null));
            this.checkAddType(so.getReturnType().getTypeDefinition());
        }
        List<String> paramNames = ServerUtils.getParameterNames(method);
        Type[] types = method.getGenericParameterTypes();
        ArrayList<FieldDefinition> params = new ArrayList<FieldDefinition>(types.length);
        so.setParameterTypes(params);
        for (int i = 0; i < types.length; ++i) {
            params.add(ReflectTypeUtils.getFieldDefinition((Type)types[i], (TypeState)typeState, (boolean)false, (String)paramNames.get(i)));
            this.checkAddType(((FieldDefinition)params.get(i)).getTypeDefinition());
        }
        this.operations.add(so);
    }

    private void checkAddType(TypeDefinition td) {
        if (null == td) {
            return;
        }
        if (this.typeDefinitions.contains(td)) {
            return;
        }
        if (td instanceof PrimitiveTypeDefinition) {
            return;
        }
        for (TypeDefinition knownType : this.typeDefinitions) {
            if (!knownType.getTypeName().equals(td.getTypeName())) continue;
            return;
        }
        if (this.excludeTypeNames.contains(td.getTypeName())) {
            return;
        }
        this.typeDefinitions.add(td);
    }

    public static Collection<Method> filterOverloadedMethods(List<Method> allMethods) {
        HashMap<String, Method> methodsMap = new HashMap<String, Method>();
        for (Method method : allMethods) {
            if (methodsMap.containsKey(method.getName())) {
                if (((Method)methodsMap.get(method.getName())).getParameterTypes().length <= method.getParameterTypes().length) continue;
                methodsMap.put(method.getName(), method);
                continue;
            }
            methodsMap.put(method.getName(), method);
        }
        return methodsMap.values();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public ServiceType getServiceType() {
        return new JavaServiceType();
    }

    @Override
    public String getRuntimeConfiguration() {
        return null;
    }

    @Override
    public String getServiceClass() {
        return this.serviceClassName;
    }

    @Override
    public List<String> getEventNotifiers() {
        return Collections.emptyList();
    }

    @Override
    public boolean isLiveDataService() {
        return this.implementsCRUDService;
    }

    @Override
    public List<TypeDefinition> getLocalTypes() {
        return this.typeDefinitions;
    }

    @Override
    public List<ServiceOperation> getServiceOperations() {
        return this.operations;
    }
}

