/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.server.DownloadResponse;
import com.wavemaker.tools.project.BuildExceptionWithOutput;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.project.ResourceManager;
import com.wavemaker.tools.project.StudioConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.ProjectHelper;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManager {
    org.apache.tools.ant.Project mAnt;
    Logger logger = Logger.getLogger(this.getClass());
    public static final String PROJECT_DIR_PROPERTY = "project.dir";
    public static final String PROJECT_NAME_PROPERTY = "project.name";
    public static final String PROJECT_NEW_NAME_PROPERTY = "project.new.name";
    public static final String PROJECT_ENCODING_PROPERTY = "project.encoding";
    public static final String TOMCAT_HOST_PROPERTY = "tomcat.host";
    public static final String TOMCAT_PORT_PROPERTY = "tomcat.port";
    public static final String DEPLOY_NAME_PROPERTY = "deploy.name";
    public static final String STUDIO_WEBAPPROOT_PROPERTY = "studio.webapproot.dir";
    public static final String WAR_FILE_NAME_PROPERTY = "war.file.name";
    public static final String EAR_FILE_NAME_PROPERTY = "ear.file.name";
    public static final String PROJ_DIRECTORY_PROPERTY = "orig.proj.dir";
    public static final String CUSTOM_WM_DIR_NAME_PROPERTY = "custom.wm.dir";
    public static final String ZIP_FILE_NAME_PROPERTY = "zip.file.name";
    public static final String ZIP_FOLDER_NAME_PROPERTY = "zip.folder.name";
    public static final String BUILD_WEBAPPROOT_PROPERTY = "build.app.webapproot.dir";
    public static final String WAVEMAKER_HOME = "wavemaker.home";
    public static final String USER_NAME_PROPERTY = "wavemaker.user.name";
    public static final String TMP_FOLDER_PROPERTY = "wavemaker.user.tmp";
    public static final String BUILD_RESOURCE_NAME = "app-deploy.xml";
    public static final String TEST_RUN_START_OPERATION = "testrunstart";
    public static final String TEST_RUN_RELOAD_OPERATION = "testrunreload";
    public static final String TEST_RUN_CLEAN_OPERATION = "testrunclean";
    public static final String UNDEPLOY_OPERATION = "undeploy";
    public static final String BUILD_OPERATION = "build";
    public static final String CLEAN_BUILD_OPERATION = "clean-build";
    public static final String COMPILE_OPERATION = "compile";
    public static final String CLEAN_COMPILE_OPERATION = "clean-compile";
    public static final String BUILD_WAR_OPERATION = "build-war";
    public static final String BUILD_EAR_OPERATION = "build-ear";
    public static final String DEPLOY_WAR_OPERATION = "deploy-war";
    public static final String EXPORT_PROJECT_OPERATION = "export-project";
    public static final String IMPORT_RENAME_UTILS_OPERATION = "import-rename-utils";
    public static final String GEN_RTFILES_OPERATION = "generate-runtime-files";
    public static final String EXPORT_DIR_DEFAULT = "export";
    public static final String DIST_DIR_DEFAULT = "dist";
    public static final String WAR_EXTENSION = ".war";
    public static final String EAR_EXTENSION = ".ear";
    public static final String PACKAGES_DIR = "packages";
    public static final String THEMES_DIR = "themes";
    public static final String LIB_JS_FILE = "lib.js";
    public static final String PACKAGES_JS_FILE = "packages.js";
    public static final String COMMON_MODULE_PREFIX = "common.packages.";
    private static boolean isCloud;
    private static boolean isCloudInitialized;
    private StudioConfiguration studioConfiguration;
    private ProjectManager projectManager;

    public static boolean isCloud() {
        if (!isCloudInitialized) {
            try {
                ClassPathResource cpr = new ClassPathResource("cloud.src.resource");
                isCloud = cpr.exists();
                isCloudInitialized = true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return isCloud;
    }

    public String testRunStart(String projectDir, String deployName) {
        HttpSession H = RuntimeAccess.getInstance().getSession();
        if (H != null && H.getAttribute("Unloader") == null) {
            H.setAttribute("Unloader", (Object)new Undeployer());
        }
        return this.antExecute(projectDir, deployName, TEST_RUN_START_OPERATION);
    }

    public String testRunStart() {
        return this.testRunStart(this.getProjectDir().getAbsolutePath(), this.getDeployName());
    }

    public String compile() {
        return this.antExecute(this.getProjectDir().getAbsolutePath(), this.getDeployName(), COMPILE_OPERATION);
    }

    public String cleanCompile() {
        return this.antExecute(this.getProjectDir().getAbsolutePath(), this.getDeployName(), CLEAN_COMPILE_OPERATION);
    }

    public String build() {
        return this.antExecute(this.getProjectDir().getAbsolutePath(), this.getDeployName(), BUILD_OPERATION);
    }

    public String generateRuntime() {
        return this.antExecute(this.getProjectDir().getAbsolutePath(), this.getDeployName(), GEN_RTFILES_OPERATION);
    }

    public String cleanBuild() {
        return this.antExecute(this.getProjectDir().getAbsolutePath(), this.getDeployName(), CLEAN_BUILD_OPERATION);
    }

    public void buildWar(String projectDir, String buildDir, String warFileName) {
        int len = warFileName.length();
        String earFileName = warFileName.substring(0, len - 4) + EAR_EXTENSION;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(BUILD_WEBAPPROOT_PROPERTY, buildDir);
        properties.put(WAR_FILE_NAME_PROPERTY, warFileName);
        properties.put(EAR_FILE_NAME_PROPERTY, earFileName);
        properties.put(CUSTOM_WM_DIR_NAME_PROPERTY, "common");
        properties.put(WAVEMAKER_HOME, this.getStudioConfiguration().getWaveMakerHome().getAbsolutePath());
        File f = new File(warFileName);
        String projDir = f.getParentFile().getParentFile().getAbsolutePath();
        properties.put(PROJ_DIRECTORY_PROPERTY, projDir);
        this.antExecute(projectDir, BUILD_WAR_OPERATION, properties);
        this.antExecute(projectDir, BUILD_EAR_OPERATION, properties);
    }

    public String buildWar() throws IOException {
        File dist = new File(this.getProjectDir(), DIST_DIR_DEFAULT);
        File warFile = new File(dist, this.getDeployName() + WAR_EXTENSION);
        return this.buildWar(warFile);
    }

    public String buildWar(File warFile) throws IOException {
        File f = warFile.getParentFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        String warFileName = warFile.getAbsolutePath();
        this.buildWar(warFileName);
        return warFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildWar(String warFileName) throws IOException {
        File tempDir = IOUtils.createTempDirectory();
        try {
            this.buildWar(this.getProjectDir().getAbsolutePath(), tempDir.getAbsolutePath(), warFileName);
        }
        finally {
            IOUtils.deleteRecursive((File)tempDir);
        }
    }

    public String deployWar(String warFileName, String deployName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(WAR_FILE_NAME_PROPERTY, warFileName);
        return this.antExecute(this.getProjectDir().getAbsolutePath(), deployName, DEPLOY_WAR_OPERATION, properties);
    }

    public String testRunClean(String projectDir, String deployName) {
        return this.antExecute(projectDir, deployName, TEST_RUN_CLEAN_OPERATION);
    }

    public String testRunClean() {
        return this.testRunClean(this.getProjectDir().getAbsolutePath(), this.getDeployName());
    }

    public String undeploy() {
        return this.undeploy(this.getProjectDir().getAbsolutePath(), this.getDeployName());
    }

    public String undeploy(String projectDir, String deployName) {
        return this.antExecute(projectDir, deployName, UNDEPLOY_OPERATION);
    }

    public String exportProject(String projectDir, String zipFileName) {
        File zipFile = new File(zipFileName);
        if (!zipFile.getParentFile().exists()) {
            zipFile.getParentFile().mkdir();
        }
        String projectName = zipFile.getName();
        projectName = projectName.substring(0, projectName.indexOf("."));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(ZIP_FILE_NAME_PROPERTY, zipFileName);
        properties.put(ZIP_FOLDER_NAME_PROPERTY, zipFile.toString().substring(0, zipFile.toString().length() - 4));
        properties.put(TMP_FOLDER_PROPERTY, this.projectManager.getTmpDir().toString());
        properties.put(PROJECT_NEW_NAME_PROPERTY, projectName);
        return this.antExecute(projectDir, EXPORT_PROJECT_OPERATION, properties);
    }

    public void exportProject(String zipFileName) {
        this.exportProject(this.getProjectDir().getAbsolutePath(), zipFileName);
    }

    public String getExportPath() {
        try {
            File exportDir = this.projectManager.getUserProjectPrefix().length() > 0 ? this.projectManager.getTmpDir() : new File(this.getProjectDir(), EXPORT_DIR_DEFAULT);
            return exportDir.getAbsolutePath() + "/" + this.getDeployName() + ".zip";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String exportProject() {
        String zipFileName = this.getExportPath();
        this.exportProject(zipFileName);
        return zipFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importFromZip(MultipartFile file) throws IOException {
        File finalProjectFolder;
        File tmpDir = this.projectManager.getTmpDir();
        DownloadResponse ret = new DownloadResponse();
        File outputFile = new File(tmpDir, file.getOriginalFilename());
        FileOutputStream fos = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)file.getInputStream(), (OutputStream)fos);
        file.getInputStream().close();
        fos.close();
        try {
            File testExistenceFile;
            File projectFolder = ResourceManager.unzipFile(outputFile);
            if (projectFolder == null) {
                throw new WMRuntimeException("That didn't look like a zip file");
            }
            int folderCount = IOUtils.countFoldersInDir((File)projectFolder);
            if (folderCount == 1) {
                File[] listing = projectFolder.listFiles();
                for (int i = 0; i < listing.length; ++i) {
                    if (!listing[i].isDirectory() || listing[i].getName().startsWith(".") || listing[i].getName().startsWith("_")) continue;
                    projectFolder = listing[i];
                    break;
                }
            }
            if (!(testExistenceFile = new File(projectFolder, "webapproot/pages")).exists()) {
                throw new WMRuntimeException("That didn't look like a project folder; if it was, files were missing");
            }
            finalProjectFolder = new File(this.projectManager.getBaseProjectDir(), this.projectManager.getUserProjectPrefix() + projectFolder.getName());
            String finalname = finalProjectFolder.getName();
            int i = -1;
            while ((finalProjectFolder = new File(finalProjectFolder.getParentFile(), finalname + (++i > 0 ? "" + i : ""))).exists()) {
            }
            finalname = finalname + i;
            projectFolder.renameTo(finalProjectFolder);
            if (i > 0) {
                File jsFile = new File(finalProjectFolder, "webapproot/" + projectFolder.getName() + ".js");
                File newJsFile = new File(finalProjectFolder, "webapproot/" + projectFolder.getName() + i + ".js");
                jsFile.renameTo(newJsFile);
                ResourceManager.ReplaceTextInFile(newJsFile, projectFolder.getName(), projectFolder.getName() + i);
                File index_html = new File(finalProjectFolder, "webapproot/index.html");
                ResourceManager.ReplaceTextInFile(index_html, "new " + projectFolder.getName() + "\\(\\{domNode", "new " + projectFolder.getName() + i + "({domNode");
                ResourceManager.ReplaceTextInFile(index_html, "\\\"" + projectFolder.getName() + "\\.js\\\"", '\"' + projectFolder.getName() + i + ".js\"");
                ResourceManager.ReplaceTextInFile(index_html, "\\<title\\>" + projectFolder.getName() + "\\<\\/title\\>", "<title>" + projectFolder.getName() + i + "</title>");
            }
        }
        finally {
            IOUtils.deleteRecursive((File)tmpDir);
        }
        return finalProjectFolder.getName().substring(this.projectManager.getUserProjectPrefix().length());
    }

    public String antExecute(String projectDir, String targetName, Map<String, String> properties) {
        return this.antExecute(projectDir, null, targetName, properties);
    }

    protected File getProjectDir() {
        Project currentProject = this.projectManager.getCurrentProject();
        if (null == currentProject) {
            throw new WMRuntimeException("Current project must be set");
        }
        File projectDir = currentProject.getProjectRoot();
        return projectDir;
    }

    protected String getDeployName() {
        return this.getDeployName(this.getProjectDir());
    }

    protected String getDeployName(File projectDir) {
        String projectName = projectDir.getName();
        if (this.projectManager.getUserProjectPrefix().length() > 0) {
            projectName = projectName.replace(this.projectManager.getUserProjectPrefix(), "");
        }
        return projectName;
    }

    private String antExecute(String projectDir, String deployName, String targetName) {
        Map<String, String> props = Collections.emptyMap();
        return this.antExecute(projectDir, deployName, targetName, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String antExecute(String projectDir, String deployName, String targetName, Map<String, String> properties) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        DefaultLogger dl = new DefaultLogger();
        dl.setErrorPrintStream(ps);
        dl.setOutputPrintStream(ps);
        dl.setMessageOutputLevel(2);
        this.mAnt = this.parseAntFile(projectDir, deployName, properties);
        for (Object bl : this.mAnt.getBuildListeners()) {
            this.mAnt.removeBuildListener((BuildListener)bl);
        }
        this.mAnt.addBuildListener(dl);
        try {
            try {
                this.logger.info((Object)"RUN ANT");
                this.mAnt.executeTarget(targetName);
                this.logger.info((Object)"END ANT");
            }
            finally {
                ps.close();
            }
        }
        catch (BuildException e) {
            this.logger.error((Object)("build failed with compiler output:\n" + baos.toString() + "\nmessage: " + e.getMessage()), (Throwable)e);
            throw new BuildExceptionWithOutput(e.getMessage(), baos.toString() + "\nmessage: " + e.getMessage(), e);
        }
        String compilerOutput = baos.toString();
        this.logger.warn((Object)("build succeeded with compiler output:\n" + compilerOutput));
        return compilerOutput;
    }

    private org.apache.tools.ant.Project parseAntFile(String projectDir, String deployName, Map<String, String> properties) {
        org.apache.tools.ant.Project ant = new org.apache.tools.ant.Project();
        StudioConfiguration studioConfiguration = this.projectManager.getStudioConfiguration();
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        if (null != this.getProjectManager() && null != this.getProjectManager().getCurrentProject()) {
            newProperties.put(PROJECT_ENCODING_PROPERTY, this.getProjectManager().getCurrentProject().getEncoding());
        }
        newProperties.put(TOMCAT_HOST_PROPERTY, this.getStudioConfiguration().getTomcatHost());
        System.setProperty("wm.proj.tomcat.host", this.getStudioConfiguration().getTomcatHost());
        newProperties.put(TOMCAT_PORT_PROPERTY, this.getStudioConfiguration().getTomcatPort());
        System.setProperty("wm.proj.tomcat.port", this.getStudioConfiguration().getTomcatPort() + "");
        newProperties.put("tomcat.manager.username", this.getStudioConfiguration().getTomcatManagerUsername());
        System.setProperty("wm.proj.tomcat.manager.username", this.getStudioConfiguration().getTomcatManagerUsername());
        newProperties.put("tomcat.manager.password", this.getStudioConfiguration().getTomcatManagerPassword());
        System.setProperty("wm.proj.tomcat.manager.password", this.getStudioConfiguration().getTomcatManagerPassword());
        newProperties.putAll(properties);
        newProperties.put(STUDIO_WEBAPPROOT_PROPERTY, studioConfiguration.getStudioWebAppRootFile().getAbsolutePath());
        newProperties.put(PROJECT_DIR_PROPERTY, projectDir);
        this.logger.info((Object)("PUT DIR: " + projectDir.toString()));
        File projectDirFile = new File(projectDir);
        String projectName = projectDirFile.getName();
        newProperties.put(PROJECT_NAME_PROPERTY, projectName);
        this.logger.info((Object)("PUT NAME: " + projectName));
        if (null != deployName) {
            newProperties.put(DEPLOY_NAME_PROPERTY, this.projectManager.getUserProjectPrefix() + deployName);
            System.setProperty("wm.proj.deploy.name", this.projectManager.getUserProjectPrefix() + deployName);
        }
        for (Map.Entry mapEntry : newProperties.entrySet()) {
            ant.setProperty((String)mapEntry.getKey(), String.valueOf(mapEntry.getValue()));
        }
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        DefaultLogger log = new DefaultLogger();
        log.setErrorPrintStream(System.err);
        log.setOutputPrintStream(System.out);
        log.setMessageOutputLevel(2);
        ant.addBuildListener(log);
        ant.init();
        helper.parse(ant, this.getClass().getResource(BUILD_RESOURCE_NAME));
        return ant;
    }

    public void deployClientComponent(String name, String namespace, String data) throws IOException {
        if (DeploymentManager.isCloud()) {
            return;
        }
        File packagesDir = new File(this.studioConfiguration.getCommonDir(), PACKAGES_DIR);
        if (!packagesDir.exists()) {
            packagesDir.mkdir();
        }
        File moduleDir = packagesDir;
        if (namespace != null && namespace.length() > 0) {
            String[] folderList;
            for (String folder : folderList = namespace.split("\\.")) {
                moduleDir = new File(moduleDir, folder);
            }
            moduleDir.mkdirs();
        }
        data = this.modifyJS(data);
        FileUtils.writeStringToFile((File)new File(moduleDir, name + ".js"), (String)data, (String)"UTF-8");
        String klass = null;
        klass = namespace != null && namespace.length() > 0 ? namespace + "." + name : name;
        String moduleString = "\"common.packages." + klass + "\"";
        boolean found = false;
        File libJsFile = new File(packagesDir, LIB_JS_FILE);
        StringBuffer libJsData = new StringBuffer();
        if (libJsFile.exists()) {
            List libJsStringList = FileUtils.readLines((File)libJsFile, (String)"UTF-8");
            for (int i = 0; i < libJsStringList.size(); ++i) {
                String s = (String)libJsStringList.get(i);
                if (s.indexOf(moduleString) > -1) {
                    found = true;
                }
                libJsData.append(s);
                libJsData.append("\n");
            }
        }
        if (!found) {
            libJsData.append("dojo.require(");
            libJsData.append(moduleString);
            libJsData.append(");\n");
        }
        FileUtils.writeStringToFile((File)libJsFile, (String)libJsData.toString(), (String)"UTF-8");
    }

    private String modifyJS(String val) {
        boolean foundDojo = false;
        boolean foundWidget = false;
        int startIndx = 0;
        int dojoIndx = -1;
        int compositeIndx = -1;
        int dojoEndIndx = -1;
        int widgetIndx = -1;
        int widgetEndIndx = -1;
        while (!foundDojo && (dojoIndx = val.indexOf("dojo.declare", startIndx)) > startIndx) {
            startIndx = dojoIndx + 12;
            compositeIndx = val.indexOf("wm.Composite", startIndx);
            if (compositeIndx < startIndx || (dojoEndIndx = val.indexOf("});", startIndx = compositeIndx + 12)) < compositeIndx) continue;
            foundDojo = true;
            break;
        }
        if (!foundDojo) {
            return val;
        }
        startIndx = dojoEndIndx;
        while (!foundWidget && (widgetIndx = val.indexOf(".components", startIndx)) > startIndx) {
            startIndx = widgetIndx + 11;
            widgetEndIndx = val.indexOf("wm.publish", startIndx);
            if (widgetEndIndx == -1) {
                widgetEndIndx = val.indexOf("wm.registerPackage", startIndx);
            }
            if (widgetEndIndx <= widgetIndx) continue;
            foundWidget = true;
            break;
        }
        if (!foundWidget) {
            return val;
        }
        boolean done = false;
        startIndx = dojoIndx;
        String rtn = val.substring(0, dojoIndx);
        while (!done) {
            int indx1 = val.indexOf("this.", startIndx);
            if (indx1 > 0) {
                int len;
                rtn = rtn + val.substring(startIndx, indx1);
                rtn = !this.validJavaVarPart(val.substring(indx1 - 1, indx1)) ? ((len = this.elemLen(val, indx1 + 5, widgetIndx, widgetEndIndx)) > 0 ? rtn + "this.components." : rtn + "this.") : rtn + "this.";
                startIndx = indx1 + 5;
                continue;
            }
            rtn = rtn + val.substring(startIndx);
            break;
        }
        return rtn;
    }

    public void deployTheme(String themename, String filename, String data) throws IOException {
        if (DeploymentManager.isCloud()) {
            return;
        }
        File themesDir = new File(this.studioConfiguration.getCommonDir(), THEMES_DIR);
        if (!themesDir.exists()) {
            themesDir.mkdir();
        }
        File moduleDir = themesDir;
        if (themename != null && themename.length() > 0) {
            String[] folderList;
            for (String folder : folderList = themename.split("\\.")) {
                moduleDir = new File(moduleDir, folder);
            }
            moduleDir.mkdirs();
        }
        FileUtils.writeStringToFile((File)new File(moduleDir, filename), (String)data, (String)"UTF-8");
    }

    public boolean undeployTheme(String themename) throws IOException {
        if (DeploymentManager.isCloud()) {
            return false;
        }
        File packagesDir = new File(this.studioConfiguration.getCommonDir() + "/" + THEMES_DIR, themename);
        if (!packagesDir.exists()) {
            return false;
        }
        IOUtils.deleteRecursive((File)packagesDir);
        return true;
    }

    public String[] listThemes() throws IOException {
        File themesDir = new File(this.studioConfiguration.getCommonDir(), THEMES_DIR);
        if (!themesDir.exists()) {
            themesDir.mkdir();
        }
        File[] files = themesDir.listFiles();
        File themesFolder = new File(this.studioConfiguration.getStudioWebAppRootFile() + "/lib/wm/base/widget", THEMES_DIR);
        File[] files2 = themesFolder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().indexOf("wm_") == 0;
            }
        });
        String[] s = new String[(files != null ? files.length : 0) + (files2 != null ? files2.length : 0)];
        int i = 0;
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                s[i] = files[i].getName();
            }
        }
        if (files2 != null) {
            for (int j = 0; j < files2.length; ++j) {
                s[i + j] = files2[j].getName();
            }
        }
        return s;
    }

    public void copyTheme(String oldName, String newName) throws IOException {
        File oldFile = new File(oldName.indexOf("wm_") == 0 ? new File(this.studioConfiguration.getStudioWebAppRootFile() + "/lib/wm/base/widget", THEMES_DIR) : new File(this.studioConfiguration.getCommonDir(), THEMES_DIR), oldName);
        File newFile = new File(this.studioConfiguration.getCommonDir() + "/" + THEMES_DIR, newName);
        IOUtils.copy((File)oldFile, (File)newFile);
        File f = new File(newFile, "theme.css");
        ResourceManager.ReplaceTextInFile(f, "\\." + oldName, "." + newName);
    }

    public void deleteTheme(String name) throws IOException {
        IOUtils.deleteRecursive((File)new File(this.studioConfiguration.getCommonDir() + "/" + THEMES_DIR, name));
    }

    public String[] listThemeImages(String themename) throws IOException {
        int i;
        File themesDir = themename.indexOf("wm_") == 0 ? new File(this.studioConfiguration.getStudioWebAppRootFile() + "/lib/wm/base/widget/themes/" + themename, "images") : new File(this.studioConfiguration.getCommonDir() + "/" + THEMES_DIR + "/" + themename, "images");
        String[] files0 = this.getImageFiles(themesDir, null, "repeat,top left,");
        String[] files1 = this.getImageFiles(themesDir, "repeat", "repeat,top left,");
        String[] files2 = this.getImageFiles(themesDir, "repeatx", "repeat-x,top left,");
        String[] files3 = this.getImageFiles(themesDir, "repeaty", "repeat-y,top left,");
        String[] files4 = this.getImageFiles(themesDir, "repeatx_bottom", "repeat-x,bottom left,");
        String[] files5 = this.getImageFiles(themesDir, "repeaty_right", "repeat-y,top right,");
        String[] s = new String[files0.length + files1.length + files2.length + files3.length + files4.length + files5.length];
        int index = 0;
        for (i = 0; i < files0.length; ++i) {
            s[index++] = files0[i];
        }
        for (i = 0; i < files1.length; ++i) {
            s[index++] = files1[i];
        }
        for (i = 0; i < files2.length; ++i) {
            s[index++] = files2[i];
        }
        for (i = 0; i < files3.length; ++i) {
            s[index++] = files3[i];
        }
        for (i = 0; i < files4.length; ++i) {
            s[index++] = files4[i];
        }
        for (i = 0; i < files5.length; ++i) {
            s[index++] = files5[i];
        }
        return s;
    }

    private String[] getImageFiles(File themeDir, String folderName, String prepend) {
        File folder = folderName == null ? themeDir : new File(themeDir, folderName);
        File[] files = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName().toLowerCase();
                return name.endsWith(".gif") || name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg");
            }
        });
        if (files != null) {
            String[] s = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                s[i] = prepend + "url(images/" + (folderName == null ? "" : folderName + "/") + files[i].getName() + ")";
            }
            return s;
        }
        String[] s = new String[]{};
        return s;
    }

    private boolean validJavaVarPart(String val) {
        char v = val.charAt(0);
        return v >= '0' && v <= '9' || v >= '@' && v <= 'Z' || v >= 'a' && v <= 'z' || v == '_';
    }

    private int elemLen(String val, int indx, int windx, int windx1) {
        int i;
        for (i = 0; i < windx && this.validJavaVarPart(val.substring(indx + i, indx + i + 1)); ++i) {
        }
        String item = val.substring(indx, indx + i);
        int j = val.substring(windx, windx1).indexOf(item);
        if (j < 0) {
            return -1;
        }
        int k = val.substring(windx + j + item.length(), windx1).indexOf(":");
        if (k < 0) {
            return -1;
        }
        String s = val.substring(windx + j + item.length(), windx + j + item.length() + k);
        if (s.trim().length() > 0) {
            return -1;
        }
        return i;
    }

    public boolean undeployClientComponent(String name, String namespace, boolean removeSource) throws IOException {
        if (DeploymentManager.isCloud()) {
            return false;
        }
        File packagesDir = new File(this.studioConfiguration.getCommonDir(), PACKAGES_DIR);
        if (!packagesDir.exists()) {
            return false;
        }
        if (removeSource) {
            File sourceJsFile;
            File moduleDir = packagesDir;
            ArrayList<File> rmDirs = new ArrayList<File>();
            if (namespace != null && namespace.length() > 0) {
                String[] folderList;
                for (String folder : folderList = namespace.split("\\.")) {
                    moduleDir = new File(moduleDir, folder);
                    rmDirs.add(moduleDir);
                }
            }
            if ((sourceJsFile = new File(moduleDir, name + ".js")).exists()) {
                File rmDir;
                IOUtils.deleteRecursive((File)sourceJsFile);
                for (int i = rmDirs.size() - 1; i > -1 && (rmDir = (File)rmDirs.get(i)).listFiles().length == 0; --i) {
                    IOUtils.deleteRecursive((File)rmDir);
                }
            }
        }
        File libJsFile = new File(packagesDir, LIB_JS_FILE);
        StringBuffer libJsData = new StringBuffer();
        if (libJsFile.exists()) {
            boolean found = false;
            String klass = null;
            klass = namespace != null && namespace.length() > 0 ? namespace + "." + name : name;
            List libJsStringList = FileUtils.readLines((File)libJsFile, (String)"UTF-8");
            for (int i = 0; i < libJsStringList.size(); ++i) {
                String s = (String)libJsStringList.get(i);
                if (s.indexOf("\"common.packages." + klass + "\"") > -1) {
                    found = true;
                    continue;
                }
                libJsData.append(s);
                libJsData.append("\n");
            }
            FileUtils.writeStringToFile((File)libJsFile, (String)libJsData.toString(), (String)"UTF-8");
            return found;
        }
        return false;
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    static {
        isCloudInitialized = false;
    }

    public static class DeploymentNamespaceMapper
    extends NamespacePrefixMapper {
        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            if ("http://www.wavemaker.com/namespaces/DeploymentPlan/1.0".equals(namespaceUri)) {
                return "";
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri)) {
                return "xsi";
            }
            return null;
        }
    }

    public class Undeployer
    implements HttpSessionBindingListener {
        private File projectDir;
        private String projectName;

        public void valueBound(HttpSessionBindingEvent event) {
            this.projectDir = DeploymentManager.this.getProjectDir();
            this.projectName = DeploymentManager.this.getDeployName(this.projectDir);
            DeploymentManager.this.logger.info((Object)("SESSION BOUND " + this.projectName + "!!!!!!!!!!!!!!!"));
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
        }
    }
}

