/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

import com.wavemaker.common.ResourceManager;
import com.wavemaker.common.util.SpringUtils;
import com.wavemaker.tools.project.StudioConfiguration;
import com.wavemaker.tools.project.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherHelper {
    public static Object invoke(ClassLoader cl, String fqClass, String methodName, Class<?>[] argTypes, Object[] args, boolean isStatic) throws ClassNotFoundException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (null == ResourceManager.getInstance()) {
            SpringUtils.initSpringConfig();
        }
        Class<?> klass = cl.loadClass(fqClass);
        Method m = klass.getMethod(methodName, argTypes);
        Object o = isStatic ? null : klass.newInstance();
        return m.invoke(o, args);
    }

    public static boolean isStudioUpgrade() throws IOException {
        VersionInfo viCurrent;
        VersionInfo viRegistered = StudioConfiguration.getRegisteredVersionInfo();
        return viRegistered.compareTo(viCurrent = StudioConfiguration.getCurrentVersionInfo()) < 0;
    }

    public static boolean isMajorUpgrade() throws IOException {
        if (LauncherHelper.isStudioUpgrade()) {
            VersionInfo viRegistered = StudioConfiguration.getRegisteredVersionInfo();
            VersionInfo viCurrent = StudioConfiguration.getCurrentVersionInfo();
            if (viRegistered.getMajor() < viCurrent.getMajor()) {
                return true;
            }
        }
        return false;
    }

    public static void doUpgrade(File waveMakerHome) throws IOException {
        VersionInfo vi = StudioConfiguration.getCurrentVersionInfo();
        StudioConfiguration.setRegisteredVersionInfo(vi);
        File oldWMHome = StudioConfiguration.staticGetWaveMakerHome();
        if (0 != oldWMHome.compareTo(waveMakerHome)) {
            FileUtils.copyDirectory((File)oldWMHome, (File)waveMakerHome);
            StudioConfiguration.setWaveMakerHome(waveMakerHome);
        }
    }

    public static String getCurrentVersionString() throws IOException {
        return StudioConfiguration.getCurrentVersionInfo().toString();
    }

    public static String getNewDefaultWMHome() throws IOException {
        File oldDefault = StudioConfiguration.getDefaultWaveMakerHome();
        return new File(oldDefault.getAbsolutePath() + " " + LauncherHelper.getCurrentVersionString()).getAbsolutePath();
    }
}

