/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.FileAccessException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.tools.project.ProjectManager;
import java.io.File;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagesManager {
    public static final String PAGE_CSS = "css";
    public static final String PAGE_HTML = "html";
    public static final String PAGE_WIDGETS = "widgets.js";
    public static final String PAGE_JS = "js";
    ProjectManager projectManager;

    public SortedSet<String> listPages() throws FileAccessException {
        return this.listPages(this.getProjectManager().getCurrentProject().getProjectName());
    }

    public SortedSet<String> listPages(String projectName) throws FileAccessException {
        TreeSet<String> ret = new TreeSet<String>();
        File pagesDir = this.getPagesDir(projectName);
        File[] children = pagesDir.listFiles();
        if (null != children) {
            for (File child : children) {
                if (!child.isDirectory() || IOUtils.DEFAULT_EXCLUSION.contains(child.getName())) continue;
                ret.add(child.getName());
            }
        }
        return ret;
    }

    public void deletePage(String pageName) throws IOException {
        File removePage = this.getPageDir(this.projectManager.getCurrentProject().getProjectName(), pageName);
        if (removePage.exists() && removePage.isDirectory()) {
            FileUtils.forceDelete((File)removePage);
        }
    }

    public void copyPage(String sourceProjectName, String sourcePaneName, String destPageName) throws IOException {
        this.copyPage(sourceProjectName, sourcePaneName, this.getProjectManager().getCurrentProject().getProjectName(), destPageName);
    }

    public void copyPage(String sourceProjectName, String sourcePageName, String destProjectName, String destPageName) throws IOException {
        File sourcePane = this.getPageDir(sourceProjectName, sourcePageName);
        if (!sourcePane.exists() || !sourcePane.isDirectory()) {
            throw new WMRuntimeException(Resource.PAGECP_SOURCEDNE, new Object[]{sourcePageName, sourceProjectName});
        }
        File destPane = this.getPageDir(destProjectName, destPageName);
        if (destPane.exists()) {
            throw new WMRuntimeException(Resource.PAGECP_TARGET_EXISTS, new Object[]{destPageName, destProjectName});
        }
        FileUtils.copyFile((File)new File(sourcePane, sourcePageName + "." + PAGE_HTML), (File)new File(destPane, destPageName + "." + PAGE_HTML));
        String cssContents = FileUtils.readFileToString((File)new File(sourcePane, sourcePageName + "." + PAGE_CSS), (String)"UTF-8");
        cssContents = cssContents.replace("." + sourcePageName, "." + destPageName);
        FileUtils.writeStringToFile((File)new File(destPane, destPageName + "." + PAGE_CSS), (String)cssContents, (String)"UTF-8");
        String jsContents = FileUtils.readFileToString((File)new File(sourcePane, sourcePageName + "." + PAGE_JS), (String)"UTF-8");
        jsContents = jsContents.replaceAll("^dojo.declare\\(\"" + sourcePageName + "\"", "dojo.declare(\"" + destPageName + "\"");
        FileUtils.writeStringToFile((File)new File(destPane, destPageName + "." + PAGE_JS), (String)jsContents, (String)"UTF-8");
        String widgetsContents = FileUtils.readFileToString((File)new File(sourcePane, sourcePageName + "." + PAGE_WIDGETS), (String)"UTF-8");
        widgetsContents = widgetsContents.replaceAll("^" + sourcePageName + ".widgets ", destPageName + ".widgets ");
        FileUtils.writeStringToFile((File)new File(destPane, destPageName + "." + PAGE_WIDGETS), (String)widgetsContents, (String)"UTF-8");
    }

    public File getPagesDir(String projectName) throws FileAccessException {
        File projectRoot = this.projectManager.getProjectDir(projectName, false);
        return new File(new File(projectRoot, "webapproot"), "pages");
    }

    public File getPageDir(String projectName, String pageName) throws FileAccessException {
        return new File(this.getPagesDir(projectName), pageName);
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }
}

