/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.tools.serializer.FileSerializerException;
import com.wavemaker.tools.serializer.FileSerializerFactory;
import com.wavemaker.tools.service.AbstractFileService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends AbstractFileService {
    public static final String PROJECT_PROPERTIES = ".wmproject.properties";
    protected static final String PROPERTY_PROJECT_VERSION = "projectVersion";
    protected static final String PROPERTY_PROJECT_VERSION_DEFAULT = "0.0";
    private final File projectRoot;

    public Project(File projectRoot) {
        this.projectRoot = projectRoot;
    }

    public File getProjectRoot() {
        return this.projectRoot;
    }

    public File getWebAppRoot() {
        return new File(this.projectRoot, "webapproot");
    }

    public File getLogFolder() {
        return new File(this.projectRoot, "logs");
    }

    public File getWebInf() {
        return new File(this.getWebAppRoot(), "WEB-INF");
    }

    public File getWebXml() {
        return new File(this.getWebInf(), "web.xml");
    }

    public File getSecurityXml() {
        return new File(this.getWebInf(), "project-security.xml");
    }

    public File getWebInfLib() {
        return new File(this.getWebInf(), "lib");
    }

    public File getWebInfClasses() {
        return new File(this.getWebInf(), "classes");
    }

    public Object readObject(String path) throws FileSerializerException {
        File f = new File(this.projectRoot, path);
        return FileSerializerFactory.getInstance().readObject(this, f);
    }

    public void writeObject(String path, Object obj) throws FileSerializerException {
        File f = new File(this.projectRoot, path);
        FileSerializerFactory.getInstance().writeObject(this, obj, f);
    }

    @Override
    public void writeFile(String path, String data) throws IOException {
        this.writeFile(path, data, false);
    }

    public void writeFile(String path, String data, boolean noClobber) throws IOException {
        File f = new File(this.projectRoot, path);
        if (f.exists()) {
            String original = IOUtils.read((File)f);
            if (original.equals(data)) {
                return;
            }
        } else {
            IOUtils.makeDirectories((File)f.getParentFile(), (File)this.projectRoot);
        }
        if (noClobber && f.exists()) {
            return;
        }
        super.writeFile(f, data);
    }

    public String getProjectName() {
        return this.projectRoot.getName();
    }

    @Override
    public File getFileServiceRoot() {
        return this.projectRoot;
    }

    public double getProjectVersion() {
        Properties props = this.getProperties();
        String version = props.getProperty(PROPERTY_PROJECT_VERSION, PROPERTY_PROJECT_VERSION_DEFAULT);
        return Double.valueOf(version);
    }

    public void setProjectVersion(Double version) {
        Properties props = this.getProperties();
        props.setProperty(PROPERTY_PROJECT_VERSION, version.toString());
        this.setProperties(props);
    }

    public void clearProperties(Class<?> clazz) {
        Properties props = this.getProperties();
        Properties newProps = new Properties();
        Iterator iter = CastUtils.cast(props.keySet().iterator());
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.startsWith(clazz.getName())) continue;
            newProps.setProperty(key, props.getProperty(key));
        }
        this.setProperties(newProps);
    }

    public Properties getProperties(Class<?> clazz) {
        return this.getProperties(clazz.getName());
    }

    public Properties getProperties(String prefix) {
        Properties rtn = new Properties();
        Properties props = this.getProperties();
        Iterator iter = CastUtils.cast(props.keySet().iterator());
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            String s = key.substring(prefix.length() + 1);
            rtn.setProperty(s, props.getProperty(key));
        }
        return rtn;
    }

    public String getProperty(Class<?> clazz, String key) {
        return this.getProperties().getProperty(this.getPropertyName(clazz, key));
    }

    public void setProperty(Class<?> clazz, String key, Object value) {
        Properties p = this.getProperties();
        p.setProperty(this.getPropertyName(clazz, key), String.valueOf(value));
        this.setProperties(p);
    }

    protected Properties getProperties() {
        Properties ret = new Properties();
        ret.setProperty(PROPERTY_PROJECT_VERSION, PROPERTY_PROJECT_VERSION_DEFAULT);
        File projectProperties = new File(this.getProjectRoot(), PROJECT_PROPERTIES);
        if (projectProperties.exists()) {
            try {
                FileInputStream is = new FileInputStream(projectProperties);
                ret.loadFromXML(is);
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        }
        return ret;
    }

    protected void setProperties(Properties props) {
        File projectProperties = new File(this.getProjectRoot(), PROJECT_PROPERTIES);
        try {
            FileOutputStream os = new FileOutputStream(projectProperties);
            props.storeToXML((OutputStream)os, "Project Properties", this.getEncoding());
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    private String getPropertyName(Class<?> clazz, String key) {
        return clazz.getName() + "." + key;
    }
}

