/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.FileAccessException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.WMAppContext;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.ProjectEventNotifier;
import com.wavemaker.tools.project.StudioConfiguration;
import com.wavemaker.tools.project.upgrade.UpgradeManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpSession;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectManager {
    public static final String OPEN_PROJECT_SESSION_NAME = "agOpenProjectName";
    public static final String _TEMPLATE_APP_RESOURCE_NAME = "com/wavemaker/tools/project/templateapp.zip";
    private static final int _UNZIP_BLOCK_SIZE = 4096;
    private final List<String> projectCopyExclusions = new ArrayList<String>(IOUtils.DEFAULT_EXCLUSION);
    private StudioConfiguration studioConfiguration;
    private ProjectEventNotifier projectEventNotifier;
    private UpgradeManager upgradeManager;
    private Project currentProject;

    public ProjectManager() {
        this.projectCopyExclusions.add("export");
        this.projectCopyExclusions.add("dist");
    }

    public File getTmpDir() {
        try {
            File tmpDir = new File(this.getBaseProjectDir().getParentFile(), "common");
            if (!tmpDir.exists()) {
                tmpDir.mkdir();
            }
            if (this.getCurrentUsername() != null && !(tmpDir = new File(tmpDir, this.getCurrentUsername())).exists()) {
                tmpDir.mkdir();
            }
            if (!(tmpDir = new File(tmpDir, "tmp")).exists()) {
                tmpDir.mkdir();
            }
            return tmpDir;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void openProject(String projectName) throws IOException {
        this.openProject(projectName, false);
    }

    public void openProject(String projectName, boolean noSession) throws IOException {
        WMAppContext wmApp;
        File f = this.getProjectDir(projectName, false);
        if (!f.exists()) {
            throw new WMRuntimeException(Resource.PROJECT_DNE, new Object[]{projectName, f});
        }
        if (!f.isDirectory()) {
            throw new WMRuntimeException(Resource.UTIL_FILEUTILS_PATHNOTDIR, new Object[]{f});
        }
        Project ret = new Project(f);
        if (null != this.currentProject) {
            this.closeProject();
        }
        if (null != this.getProjectEventNotifier()) {
            this.getProjectEventNotifier().executeOpenProject(this.currentProject);
        }
        this.setCurrentProject(ret);
        if (!noSession) {
            RuntimeAccess.getInstance().getSession().setAttribute(OPEN_PROJECT_SESSION_NAME, (Object)projectName);
            RuntimeAccess.getInstance().getSession().setAttribute("currentProjectManager", (Object)this);
            RuntimeAccess.getInstance().getSession().setAttribute("currentProjectName", (Object)projectName);
            RuntimeAccess.getInstance().getSession().setAttribute("currentProjectRoot", (Object)ret.getWebAppRoot().getAbsolutePath());
        }
        String appPropPath = ret.getWebAppRoot().getAbsolutePath() + "/WEB-INF/classes/" + "app.properties";
        FileInputStream is = null;
        boolean fileExists = true;
        int defTenantID = 999;
        String tenantFieldName = "None";
        String tenantColumnName = "";
        try {
            is = new FileInputStream(appPropPath);
        }
        catch (FileNotFoundException ne) {
            fileExists = false;
        }
        if (fileExists) {
            Properties props = new Properties();
            props.load(is);
            tenantFieldName = props.getProperty("tenantIdField");
            defTenantID = Integer.parseInt(props.getProperty("defTenantId"));
            tenantColumnName = props.getProperty("tenantIdField");
        }
        if ((wmApp = WMAppContext.getInstance()) != null) {
            wmApp.setTenantInfoForProj(projectName, tenantFieldName, defTenantID, tenantColumnName);
        }
    }

    public void newProject(String projectName) throws IOException {
        this.newProject(this.studioConfiguration.getProjectsDir().getAbsolutePath(), projectName, false);
    }

    public void newProject(String projectName, boolean noTemplate) throws IOException {
        this.newProject(this.studioConfiguration.getProjectsDir().getAbsolutePath(), projectName, noTemplate);
    }

    private void newProject(String path, String projectName, boolean noTemplate) throws IOException {
        this.checkNewProject(projectName);
        File f = new File(path);
        File projectFile = new File(f, projectName);
        if (!projectFile.exists()) {
            if (noTemplate) {
                projectFile.mkdir();
            } else {
                this.createProjectFromTemplate(projectFile);
            }
        } else if (projectFile.exists() && !projectFile.isDirectory()) {
            throw new WMRuntimeException(Resource.UTIL_FILEUTILS_PATHNOTDIR, new Object[]{projectFile});
        }
        this.openProject(projectName);
        this.getCurrentProject().setProjectVersion(this.getUpgradeManager().getCurrentVersion());
    }

    public void copyProject(String sourceProjectName, String destinationProjectName) throws IOException {
        File indexHtml;
        File sourceProject = this.getProjectDir(sourceProjectName, false);
        File destProject = this.getProjectDir(destinationProjectName, true);
        if (!sourceProject.exists()) {
            throw new WMRuntimeException(Resource.PROJECTCOPY_SOURCE_DNE, new Object[]{sourceProjectName});
        }
        if (destProject.exists()) {
            throw new WMRuntimeException(Resource.PROJECTCOPY_DEST_DE, new Object[]{sourceProjectName});
        }
        IOUtils.copy((File)sourceProject, (File)destProject, this.projectCopyExclusions);
        File tomcatXml = new File(destProject, sourceProjectName + ".xml");
        if (tomcatXml.exists()) {
            tomcatXml.delete();
        }
        String shortSourceName = sourceProjectName.substring(this.getUserProjectPrefix().length());
        String shortDestName = destinationProjectName.substring(this.getUserProjectPrefix().length());
        String serviceStr = "\"service\":\"" + shortSourceName + "\"";
        String dummyStr = "nothingicandoifyouwanttoscrewup";
        File sourceJS = new File(destProject, "webapproot/" + shortSourceName + ".js");
        if (sourceJS.exists()) {
            File destJS = new File(destProject, "webapproot/" + shortDestName + ".js");
            String sourceJSStr = FileUtils.readFileToString((File)sourceJS, (String)"UTF-8");
            sourceJSStr = sourceJSStr.replace(serviceStr, dummyStr);
            String destJSStr = sourceJSStr.replace("\"" + shortSourceName + "\"", "\"" + shortDestName + "\"");
            destJSStr = destJSStr.replace(shortSourceName + ".extend(", shortDestName + ".extend(");
            destJSStr = destJSStr.replace(dummyStr, serviceStr);
            FileUtils.writeStringToFile((File)destJS, (String)destJSStr, (String)"UTF-8");
            sourceJS.delete();
        }
        if ((indexHtml = new File(destProject, "webapproot/index.html")).exists()) {
            String indexHtmlStr = FileUtils.readFileToString((File)indexHtml, (String)"UTF-8");
            indexHtmlStr = indexHtmlStr.replace(": " + shortSourceName + "<", ": " + shortDestName + "<");
            indexHtmlStr = indexHtmlStr.replace(">" + shortSourceName + "<", ">" + shortDestName + "<");
            indexHtmlStr = indexHtmlStr.replace("- " + shortSourceName + " -", "- " + shortDestName + " -");
            indexHtmlStr = indexHtmlStr.replace("\"" + shortSourceName + ".js\"", "\"" + shortDestName + ".js\"");
            indexHtmlStr = indexHtmlStr.replace("new " + shortSourceName + "(", "new " + shortDestName + "(");
            FileUtils.writeStringToFile((File)indexHtml, (String)indexHtmlStr, (String)"UTF-8");
        }
    }

    public File getProjectDir(String projectName, boolean ignoreDemos) throws FileAccessException {
        File demoRet;
        File ret = new File(this.getBaseProjectDir(), projectName);
        if (!ret.exists() && null != this.studioConfiguration.getDemoDir() && (demoRet = new File(this.studioConfiguration.getDemoDir(), projectName)).exists()) {
            ret = demoRet;
        }
        return ret;
    }

    public File getBaseProjectDir() throws FileAccessException {
        File ret = new File(this.studioConfiguration.getProjectsDir().toString());
        return ret;
    }

    private void createProjectFromTemplate(File projectFile) throws IOException {
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(_TEMPLATE_APP_RESOURCE_NAME);
        ZipInputStream resourceZipStream = new ZipInputStream(resourceStream);
        ZipEntry zipEntry = null;
        byte[] data = new byte[4096];
        while ((zipEntry = resourceZipStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) {
                File d = new File(projectFile, zipEntry.getName());
                d.mkdirs();
                continue;
            }
            File zipEntryFile = new File(projectFile, zipEntry.getName());
            FileOutputStream fos = new FileOutputStream(zipEntryFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 4096);
            int byteCount = 0;
            while ((byteCount = resourceZipStream.read(data, 0, 4096)) != -1) {
                bos.write(data, 0, byteCount);
            }
            bos.flush();
            bos.close();
        }
        resourceZipStream.close();
    }

    public void deleteProject(String projectName) throws IOException {
        File logFolder;
        File projectDir = this.getProjectDir(projectName, false);
        if (projectDir.exists() && projectDir.isDirectory()) {
            FileUtils.forceDelete((File)projectDir);
        }
        if ((logFolder = new File(System.getProperty("catalina.home") + "/logs/ProjectLogs", projectName)).exists() && logFolder.isDirectory()) {
            FileUtils.forceDelete((File)logFolder);
        }
    }

    public void closeProject() throws IOException {
        RuntimeAccess.getInstance().getSession().removeAttribute(OPEN_PROJECT_SESSION_NAME);
        if (null == this.currentProject) {
            return;
        }
        if (null != this.getProjectEventNotifier()) {
            this.getProjectEventNotifier().executeCloseProject(this.currentProject);
        }
        this.currentProject = null;
    }

    public SortedSet<String> listProjects(String prefixIn) throws FileAccessException {
        File demoDir;
        File temp;
        final String prefix = prefixIn;
        TreeSet<String> ret = new TreeSet<String>();
        File projectsDir = this.studioConfiguration.getProjectsDir();
        if (null != projectsDir && projectsDir.exists()) {
            for (String possibleProject : projectsDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            })) {
                if (!this.checkProjectName(possibleProject) || !(temp = new File(projectsDir, possibleProject)).isDirectory()) continue;
                ret.add(possibleProject);
            }
        }
        if (null != (demoDir = this.studioConfiguration.getDemoDir()) && demoDir.exists()) {
            for (String possibleProject : demoDir.list()) {
                if (possibleProject.startsWith(".") || !(temp = new File(demoDir, possibleProject)).isDirectory()) continue;
                ret.add(possibleProject);
            }
        }
        return ret;
    }

    public void checkNewProject(String projectName) {
        File demoProject;
        if (null != this.studioConfiguration.getDemoDir() && (demoProject = new File(this.studioConfiguration.getDemoDir(), projectName)).exists() && demoProject.isDirectory()) {
            throw new WMRuntimeException(Resource.PROJECT_CONFLICT, new Object[]{projectName});
        }
        if (!this.checkProjectName(projectName)) {
            throw new WMRuntimeException(Resource.PROJECT_INVALID_NAME, new Object[]{projectName});
        }
    }

    protected boolean checkProjectName(String projectName) {
        return !projectName.startsWith(".") && !projectName.contains(" ");
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }

    public ProjectEventNotifier getProjectEventNotifier() {
        return this.projectEventNotifier;
    }

    public void setProjectEventNotifier(ProjectEventNotifier projectEventNotifier) {
        this.projectEventNotifier = projectEventNotifier;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public String getUserProjectPrefix() {
        String s = this.getCurrentUsername();
        if (s == null) {
            return "";
        }
        return s + "___";
    }

    public String getCurrentUsername() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String username = authentication.getName();
            username = username.replaceAll("_", "__");
            username = username.replaceAll("\\.", "_DOT_");
            username = username.replaceAll("@", "_AT_");
            return username;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Project getCurrentProject() {
        HttpSession sess;
        String sessionProjectName;
        if (null == this.currentProject && null != (sessionProjectName = (String)(sess = RuntimeAccess.getInstance().getSession()).getAttribute(OPEN_PROJECT_SESSION_NAME))) {
            try {
                this.openProject(sessionProjectName);
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        }
        if (null == this.currentProject) {
            throw new WMRuntimeException(Resource.NO_PROJECT_FROM_SESSION);
        }
        return this.currentProject;
    }

    private void setCurrentProject(Project currentProject) {
        this.currentProject = currentProject;
    }
}

