/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

import com.wavemaker.common.util.IOUtils;
import com.wavemaker.runtime.server.DownloadResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.springframework.web.multipart.MultipartFile;

public class ResourceManager {
    public static DownloadResponse downloadFile(File f, String filename, boolean isZip) throws IOException {
        DownloadResponse ret = new DownloadResponse();
        FileInputStream fis = new FileInputStream(f);
        ret.setContents(fis);
        ret.setContentType(isZip ? "application/zip" : "application/unknown");
        ret.setFileName(filename);
        return ret;
    }

    public static File createZipFile(File f, File tmpDir) {
        File destFile = new File(tmpDir, f.getName() + ".zip");
        try {
            FileOutputStream dest = new FileOutputStream(destFile.toString());
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            ResourceManager.addToZipStream(f, out, "");
            out.close();
            return destFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addToZipStream(File f, ZipOutputStream out, String path) {
        System.out.println("add to stream: " + path + "/" + f.getName());
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        BufferedInputStream origin = null;
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().startsWith(".")) continue;
            if (files[i].isDirectory()) {
                System.out.println("PATH:" + path + ", NAME: " + f.getName());
                ResourceManager.addToZipStream(files[i], out, path + "/" + f.getName());
                continue;
            }
            try {
                int count;
                FileInputStream fi = new FileInputStream(files[i].toString());
                origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(path + "/" + f.getName() + "/" + files[i].getName());
                System.out.println("Adding: " + path + "/" + f.getName() + "/" + files[i].getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static String uploadFile(MultipartFile file, File tmpDir) throws IOException {
        DownloadResponse ret = new DownloadResponse();
        File outputFile = new File(tmpDir, file.getOriginalFilename());
        FileOutputStream fos = new FileOutputStream(outputFile);
        IOUtils.copy((InputStream)file.getInputStream(), (OutputStream)fos);
        file.getInputStream().close();
        fos.close();
        return file.getOriginalFilename();
    }

    public static Hashtable[] getListing(File curdir, File jarListFile) {
        File[] listing = curdir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf(".") != 0;
            }
        });
        Hashtable[] myfiles = new Hashtable[listing.length];
        for (int i = 0; i < listing.length; ++i) {
            Hashtable<String, Object> F = new Hashtable<String, Object>();
            String name = listing[i].getName();
            F.put("file", name);
            myfiles[i] = F;
            if (listing[i].isDirectory()) {
                F.put("type", "folder");
                F.put("files", ResourceManager.getListing(listing[i], jarListFile));
                continue;
            }
            F.put("type", "file");
            if (!name.endsWith(".jar")) continue;
            F.put("isInClassPath", ResourceManager.isJarInClassPath(listing[i], jarListFile));
        }
        return myfiles;
    }

    public static boolean isJarInClassPath(File resourceFile, File jarListFile) {
        if (!jarListFile.exists()) {
            return false;
        }
        try {
            String[] fileList = IOUtils.read((File)jarListFile).split("\n");
            for (int i = 0; i < fileList.length; ++i) {
                if (!resourceFile.equals(new File(jarListFile.getParentFile(), fileList[i]))) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void ReplaceTextInFile(File f, String findText, String replaceText) {
        try {
            String newtext = IOUtils.read((File)f);
            newtext = newtext.replaceAll(findText, replaceText);
            IOUtils.write((File)f, (String)newtext);
        }
        catch (Exception e) {
            System.out.println("ERROR:" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static File unzipFile(File zipfile) {
        int BUFFER = 2048;
        String zipname = zipfile.getName();
        int extindex = zipname.lastIndexOf(".");
        String folderName = extindex == -1 ? zipname + "_folder" : zipname.substring(0, extindex);
        File zipFolder = new File(zipfile.getParentFile(), folderName);
        zipFolder.mkdir();
        File currentDir = zipFolder;
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(zipfile.toString());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                if (entry.isDirectory()) {
                    File f = new File(currentDir, entry.getName());
                    if (f.exists()) {
                        f.delete();
                    }
                    f.mkdir();
                    continue;
                }
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(currentDir.toString() + "/" + entry.getName());
                dest = new BufferedOutputStream(fos, BUFFER);
                while ((count = zis.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
            zipfile.delete();
            File[] currentDirFiles = currentDir.listFiles();
            if (currentDirFiles.length == 1) {
                File newtmpfile;
                if (currentDir.getName().equals(currentDirFiles[0].getName())) {
                    newtmpfile = new File(currentDir.getParent(), "tmp");
                    currentDirFiles[0].renameTo(newtmpfile);
                    currentDir.delete();
                    newtmpfile.renameTo(currentDir);
                } else {
                    newtmpfile = new File(currentDir.getParent(), currentDirFiles[0].getName());
                    currentDirFiles[0].renameTo(newtmpfile);
                    currentDir.delete();
                    currentDir = newtmpfile;
                }
            }
            return currentDir;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

