/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.FileAccessException;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.tools.config.ConfigurationStore;
import com.wavemaker.tools.project.VersionInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioConfiguration {
    public static final String MARKER_RESOURCE_NAME = "marker.resource.txt";
    public static final String WAVEMAKER_HOME = "WaveMaker";
    public static final String PROJECTS_DIR = "projects";
    public static final String COMMON_DIR = "common";
    public static final String PROJECTHOME_KEY = "projectsDir";
    public static final String DEMOHOME_KEY = "demoHome";
    public static final String WMHOME_KEY = "wavemakerHome";
    public static final String PROJECTHOME_PROP_KEY = "wm.projectsDir";
    public static final String WMHOME_PROP_KEY = "wm.wavemakerHome";
    protected static final String TOMCAT_MANAGER_USER_KEY = "managerUser";
    protected static final String TOMCAT_MANAGER_PW_KEY = "managerPassword";
    protected static final String TOMCAT_PORT_KEY = "tomcatPort";
    protected static final String TOMCAT_HOST_KEY = "tomcatHost";
    protected static final String TOMCAT_MANAGER_USER_ENV = "wm.managerUser";
    protected static final String TOMCAT_MANAGER_PASSWORD_ENV = "wm.managerPassword";
    protected static final String TOMCAT_PORT_ENV = "wm.tomcatPort";
    protected static final String TOMCAT_HOST_ENV = "wm.tomcatHost";
    public static final int TOMCAT_PORT_DEFAULT = 8080;
    protected static final String TOMCAT_HOST_DEFAULT = "localhost";
    protected static final String TOMCAT_MANAGER_PW_DEFAULT = "manager";
    protected static final String TOMCAT_MANAGER_USER_DEFAULT = "manager";
    protected static final String VERSION_KEY = "studioVersion";
    protected static final String VERSION_DEFAULT = "4.0.0";
    public static final String CMD_GET = "get";
    public static final String CMD_SET = "set";
    protected static final String CMD_DEL = "del";
    protected static final String CMD_NOTSET = "NOTSET";
    protected static final String VERSION_FILE = "version";
    private File testWMHome = null;
    private File testDemoDir = null;
    private static boolean isCloud;
    private static boolean isCloudInitialized;
    private RuntimeAccess runtimeAccess;

    public File getProjectsDir() throws FileAccessException {
        String env = null;
        if (this.isRuntime()) {
            RuntimeAccess R = RuntimeAccess.getInstance();
            HttpServletRequest R2 = R.getRequest();
            HttpSession H = R.getSession();
            env = (String)RuntimeAccess.getInstance().getSession().getAttribute(PROJECTHOME_PROP_KEY);
        } else {
            env = System.getProperty(PROJECTHOME_PROP_KEY, null);
        }
        if (null != env && 0 != env.length()) {
            return new File(env);
        }
        File ret = new File(this.getWaveMakerHome(), PROJECTS_DIR);
        if (!ret.exists()) {
            com.wavemaker.common.util.IOUtils.makeDirectories((File)ret, (File)this.getWaveMakerHome());
        }
        return ret;
    }

    private boolean isRuntime() {
        try {
            if (RuntimeAccess.getInstance() != null && RuntimeAccess.getInstance().getRequest() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isCloud() {
        if (!isCloudInitialized) {
            try {
                ClassPathResource cpr = new ClassPathResource("cloud.src.resource");
                isCloud = cpr.exists();
                isCloudInitialized = true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return isCloud;
    }

    public static void setWaveMakerHome(File file) throws FileAccessException {
        if (StudioConfiguration.isCloud()) {
            return;
        }
        ConfigurationStore.setVersionedPreference(StudioConfiguration.class, WMHOME_KEY, file.getAbsolutePath());
        if (!file.exists()) {
            com.wavemaker.common.util.IOUtils.makeDirectories((File)file, (File)file.getParentFile());
        }
        StudioConfiguration.setupDeploymentTargetXML();
    }

    public void setTestWaveMakerHome(File file) {
        this.testWMHome = file;
    }

    public File getWaveMakerHome() {
        if (null != this.testWMHome) {
            return this.testWMHome;
        }
        return StudioConfiguration.staticGetWaveMakerHome();
    }

    public static File staticGetWaveMakerHome() {
        String pref;
        File ret = null;
        String env = System.getProperty(WMHOME_PROP_KEY, null);
        if (null != env && 0 != env.length()) {
            ret = new File(env);
        }
        if (null == ret && null != (pref = ConfigurationStore.getPreference(StudioConfiguration.class, WMHOME_KEY, null)) && 0 != pref.length()) {
            ret = new File(pref);
        }
        if (null == ret) {
            ret = StudioConfiguration.getDefaultWaveMakerHome();
        }
        if (!ret.exists()) {
            ret.mkdir();
        }
        return ret;
    }

    protected static File getDefaultWaveMakerHome() {
        String sub;
        String osVersionStr;
        File userHome = null;
        if (SystemUtils.IS_OS_WINDOWS && null != System.getenv("USERPROFILE")) {
            userHome = new File(System.getenv("USERPROFILE"));
        }
        if (null == userHome) {
            userHome = new File(System.getProperty("user.home"));
        }
        if ((osVersionStr = System.getProperty("os.version")).contains(".") && (sub = osVersionStr.substring(osVersionStr.indexOf(".") + 1)).contains(".")) {
            osVersionStr = osVersionStr.substring(0, osVersionStr.indexOf(46, osVersionStr.indexOf(46) + 1));
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            userHome = FileSystemView.getFileSystemView().getDefaultDirectory();
        } else if (SystemUtils.IS_OS_MAC) {
            userHome = new File(userHome, "Documents");
        }
        if (!userHome.exists()) {
            throw new WMRuntimeException(Resource.PROJECT_USERHOMEDNE, new Object[]{userHome});
        }
        File wmHome = new File(userHome, WAVEMAKER_HOME);
        if (!wmHome.exists()) {
            wmHome.mkdir();
        }
        return wmHome;
    }

    public File getDemoDir() {
        if (StudioConfiguration.isCloud()) {
            return null;
        }
        if (null != this.testDemoDir) {
            return this.testDemoDir;
        }
        String location = ConfigurationStore.getPreference(this.getClass(), DEMOHOME_KEY, null);
        File ret = null != location ? new File(location) : new File(this.getStudioWebAppRootFile(), "../Samples");
        return ret;
    }

    public void setDemoDir(File file) {
        if (StudioConfiguration.isCloud()) {
            return;
        }
        ConfigurationStore.setPreference(this.getClass(), DEMOHOME_KEY, file.getAbsolutePath());
    }

    public void setTestDemoDir(File file) {
        if (StudioConfiguration.isCloud()) {
            return;
        }
        this.testDemoDir = file;
    }

    public File getCommonDir() throws IOException {
        File ret = new File(this.getWaveMakerHome(), COMMON_DIR);
        if (!ret.exists() && this.getWaveMakerHome().exists()) {
            this.createCommonDir(ret);
        }
        return ret;
    }

    private synchronized void createCommonDir(File commonDir) throws IOException {
        File templateFile;
        if (!commonDir.exists() && (templateFile = new File(this.getStudioWebAppRootFile(), "lib/wm/common")).exists()) {
            com.wavemaker.common.util.IOUtils.copy((File)templateFile, (File)commonDir, (List)com.wavemaker.common.util.IOUtils.DEFAULT_EXCLUSION);
        }
    }

    public int getTomcatPort() {
        String propVal = System.getProperty(TOMCAT_PORT_ENV, null);
        if (null != propVal) {
            return Integer.parseInt(propVal);
        }
        int defaultValue = null != this.getRuntimeAccess() && null != this.getRuntimeAccess().getRequest() ? this.getRuntimeAccess().getRequest().getServerPort() : 8080;
        return ConfigurationStore.getPreferenceInt(this.getClass(), TOMCAT_PORT_KEY, defaultValue);
    }

    public String getTomcatHost() {
        String propVal = System.getProperty(TOMCAT_HOST_ENV, null);
        if (null != propVal) {
            return propVal;
        }
        String defaultValue = null != this.getRuntimeAccess() && null != this.getRuntimeAccess().getRequest() ? this.getRuntimeAccess().getRequest().getServerName() : TOMCAT_HOST_DEFAULT;
        return ConfigurationStore.getPreference(this.getClass(), TOMCAT_HOST_KEY, defaultValue);
    }

    public String getTomcatManagerUsername() {
        String propVal = System.getProperty(TOMCAT_MANAGER_USER_ENV, null);
        if (null != propVal) {
            return propVal;
        }
        return ConfigurationStore.getPreference(this.getClass(), TOMCAT_MANAGER_USER_KEY, "manager");
    }

    public String getTomcatManagerPassword() {
        String propVal = System.getProperty(TOMCAT_MANAGER_PASSWORD_ENV, null);
        if (null != propVal) {
            return propVal;
        }
        return ConfigurationStore.getPreference(this.getClass(), TOMCAT_MANAGER_PW_KEY, "manager");
    }

    public File getStudioWebAppRootFile() {
        URL url = this.getClass().getClassLoader().getResource(MARKER_RESOURCE_NAME);
        if (url == null) {
            throw new RuntimeException("Could not find resource marker.resource.txt");
        }
        try {
            String decodedURL = URLDecoder.decode(url.getFile(), "UTF-8");
            File markerFile = new File(decodedURL);
            File webAppRootFile = markerFile.getParentFile().getParentFile().getParentFile();
            return webAppRootFile;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getPreferencesMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(WMHOME_KEY, this.getWaveMakerHome().getAbsolutePath());
        ret.put(DEMOHOME_KEY, StudioConfiguration.isCloud() ? null : this.getDemoDir().getAbsolutePath());
        return ret;
    }

    public void setPreferencesMap(Map<String, String> prefs) throws FileAccessException {
        if (StudioConfiguration.isCloud()) {
            return;
        }
        if (prefs.containsKey(WMHOME_KEY) && null != prefs.get(WMHOME_KEY)) {
            StudioConfiguration.setWaveMakerHome(new File(prefs.get(WMHOME_KEY)));
        }
        if (prefs.containsKey(DEMOHOME_KEY) && null != prefs.get(DEMOHOME_KEY)) {
            this.setDemoDir(new File(prefs.get(DEMOHOME_KEY)));
        }
    }

    public static VersionInfo getCurrentVersionInfo() throws IOException {
        String versionFileString = StudioConfiguration.getCurrentVersionInfoString();
        Pattern p = Pattern.compile("^Version: (.*)$", 8);
        Matcher m = p.matcher(versionFileString);
        if (!m.find()) {
            throw new WMRuntimeException("bad version string: " + versionFileString);
        }
        return new VersionInfo(m.group(1));
    }

    public static String getCurrentVersionInfoString() throws IOException {
        String versionFile = StudioConfiguration.class.getPackage().getName().replace(".", "/") + "/" + VERSION_FILE;
        InputStream is = StudioConfiguration.class.getClassLoader().getResourceAsStream(versionFile);
        String versionFileString = IOUtils.toString((InputStream)is);
        return versionFileString;
    }

    public static void setRegisteredVersionInfo(VersionInfo vi) {
        ConfigurationStore.setPreference(StudioConfiguration.class, VERSION_KEY, vi.toString());
    }

    public static VersionInfo getRegisteredVersionInfo() {
        String versionString = ConfigurationStore.getPreference(StudioConfiguration.class, VERSION_KEY, VERSION_DEFAULT);
        return new VersionInfo(versionString);
    }

    public RuntimeAccess getRuntimeAccess() {
        return this.runtimeAccess;
    }

    public void setRuntimeAccess(RuntimeAccess runtimeAccess) {
        this.runtimeAccess = runtimeAccess;
    }

    public static void setupDeploymentTargetXML() {
        try {
            int len;
            String name = "com/wavemaker/tools/deployment/xmlhandlers/deploymentTargets.xml";
            InputStream in = StudioConfiguration.class.getClassLoader().getResourceAsStream(name);
            File efile = new File(StudioConfiguration.staticGetWaveMakerHome().getAbsolutePath(), "deploymentTargets.xml");
            if (efile.exists()) {
                return;
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(efile));
            byte[] buffer = new byte[2048];
            while ((len = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WMRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws FileAccessException {
        if (args.length <= 1) throw new WMRuntimeException("bad cmdline: " + Arrays.toString(args));
        String command = args[0];
        String key = args[1];
        if (CMD_GET.equals(command)) {
            System.out.println(ConfigurationStore.getPreference(StudioConfiguration.class, key, CMD_NOTSET));
            return;
        } else if (CMD_DEL.equals(command)) {
            ConfigurationStore.removePreference(StudioConfiguration.class, key);
            return;
        } else {
            if (!CMD_SET.equals(command)) throw new WMRuntimeException("unknown command: " + command);
            if (args.length < 3) {
                throw new WMRuntimeException("need more args for set: " + Arrays.toString(args));
            }
            StudioConfiguration.setWaveMakerHome(new File(args[2]));
        }
    }

    static {
        isCloudInitialized = false;
    }
}

