/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionInfo
implements Comparable<VersionInfo> {
    private int major;
    private int minor;
    private int revision;
    private boolean isRelease;
    private String releaseStatus;

    public VersionInfo(String versionString) {
        int firstDot = versionString.indexOf(46);
        int secondDot = versionString.indexOf(46, firstDot + 1);
        String major = versionString.substring(0, firstDot);
        String minor = versionString.substring(firstDot + 1, secondDot);
        String revisionStatus = versionString.substring(secondDot + 1);
        this.major = Integer.parseInt(major);
        this.minor = Integer.parseInt(minor);
        this.revision = Integer.parseInt(revisionStatus.substring(0, 1));
        for (int i = 1; i < revisionStatus.length(); ++i) {
            try {
                this.revision = Integer.parseInt(revisionStatus.substring(0, i));
                continue;
            }
            catch (NumberFormatException e) {
                this.releaseStatus = revisionStatus.substring(i - 1);
                break;
            }
        }
        this.isRelease = null == this.releaseStatus;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isRelease() {
        return this.isRelease;
    }

    public String getReleaseStatus() {
        return this.releaseStatus;
    }

    public String toString() {
        return this.getMajor() + "." + this.getMinor() + "." + this.getRevision() + (null != this.getReleaseStatus() ? this.getReleaseStatus() : "");
    }

    @Override
    public int compareTo(VersionInfo o) {
        VersionInfo other = o;
        int majorDiff = this.getMajor() - other.getMajor();
        if (0 != majorDiff) {
            return majorDiff;
        }
        int minorDiff = this.getMinor() - other.getMinor();
        if (0 != minorDiff) {
            return minorDiff;
        }
        int revisionDiff = this.getRevision() - other.getRevision();
        if (0 != revisionDiff) {
            return revisionDiff;
        }
        if (this.isRelease() && other.isRelease()) {
            return 0;
        }
        if (null == this.getReleaseStatus() && null != other.getReleaseStatus()) {
            return 1;
        }
        if (null != this.getReleaseStatus() && null == other.getReleaseStatus()) {
            return -1;
        }
        return this.getReleaseStatus().compareTo(other.getReleaseStatus());
    }
}

