/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.json.JSON;
import com.wavemaker.json.JSONMarshaller;
import com.wavemaker.json.JSONState;
import com.wavemaker.json.JSONUnmarshaller;
import com.wavemaker.tools.project.PagesManager;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;

public abstract class AbstractWidgetsJSUpgradeTask
implements UpgradeTask {
    private PagesManager pagesManager;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        if (null == this.getPagesManager()) {
            throw new WMRuntimeException("No pagesManager in doUpgrade()");
        }
        try {
            for (String page : this.getPagesManager().listPages()) {
                File pageDir = this.getPagesManager().getPageDir(project.getProjectName(), page);
                File widgetsJS = new File(pageDir, page + "." + "widgets.js");
                if (!widgetsJS.exists()) continue;
                this.readAndUpgradeWidgets(project, widgetsJS);
            }
            File appJs = new File(project.getWebAppRoot(), project.getProjectName() + ".js");
            if (this.doUpgradeAppJS() && appJs.exists()) {
                this.readAndUpgradeWidgets(project, appJs);
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    private void readAndUpgradeWidgets(Project project, File widgetsJS) throws IOException {
        String contents = project.readFile(widgetsJS);
        String jsonString = contents.substring(contents.indexOf(123), contents.lastIndexOf(125) + 1);
        JSON j = JSONUnmarshaller.unmarshal((String)jsonString);
        this.upgradeWidgetsJS(j);
        JSONState js = new JSONState();
        js.setUnquoteKeys(true);
        String ret = contents.substring(0, contents.indexOf(123)) + JSONMarshaller.marshal((Object)j, (JSONState)js, (boolean)false, (boolean)true) + contents.substring(contents.lastIndexOf(125) + 1);
        project.writeFile(widgetsJS, ret);
    }

    public abstract void upgradeWidgetsJS(JSON var1);

    public abstract boolean doUpgradeAppJS();

    public PagesManager getPagesManager() {
        return this.pagesManager;
    }

    public void setPagesManager(PagesManager pagesManager) {
        this.pagesManager = pagesManager;
    }
}

