/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade;

import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveObsoleteFilesUpgradeTask
implements UpgradeTask {
    private List<String> files;

    @Override
    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        for (String file : this.files) {
            File f = new File(project.getProjectRoot(), file);
            f.delete();
        }
        upgradeInfo.addMessage("Removed obsolete files: " + StringUtils.join(this.files, (String)", "));
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public List<String> getFiles() {
        return this.files;
    }
}

