/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.config.ConfigurationStore;
import com.wavemaker.tools.project.DeploymentManager;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.StudioUpgradeTask;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeManager
implements InitializingBean {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected static final String STUDIO_VERSION_KEY = "StudioVersion";
    private SortedMap<Double, List<UpgradeTask>> upgrades;
    private SortedMap<Double, List<StudioUpgradeTask>> studioUpgrades;
    private DeploymentManager deploymentManager;

    public UpgradeInfo doUpgrades(Project project) {
        double projectMaxVersion;
        double projectVersion = project.getProjectVersion();
        if (projectVersion > (projectMaxVersion = this.getCurrentVersion())) {
            throw new WMRuntimeException(Resource.PROJECT_NEWER_THAN_STUDIO, new Object[]{project.getProjectName(), projectVersion, projectMaxVersion});
        }
        if (projectVersion < projectMaxVersion) {
            UpgradeInfo ret = new UpgradeInfo();
            File exportFile = new File(new File(project.getProjectRoot(), "export"), project.getProjectName() + "-upgrade-" + projectVersion + ".zip");
            this.deploymentManager.exportProject(exportFile.getAbsolutePath());
            ret.setBackupExportFile(exportFile);
            this.deploymentManager.testRunClean();
            for (Map.Entry<Double, List<UpgradeTask>> entry : this.getUpgrades().entrySet()) {
                if (entry.getKey() <= projectVersion) continue;
                ret.setVersion(entry.getKey());
                for (UpgradeTask task : entry.getValue()) {
                    this.logger.debug((Object)("Running upgrade task " + task + " on project " + project));
                    task.doUpgrade(project, ret);
                }
                project.setProjectVersion(entry.getKey());
            }
            return ret;
        }
        return null;
    }

    public double getCurrentVersion() {
        return this.getUpgrades().lastKey();
    }

    public void afterPropertiesSet() {
        this.doStudioUpgrade();
    }

    public void doStudioUpgrade() {
        double studioMaxVersion;
        double studioVersion = UpgradeManager.getStudioVersion();
        if (studioVersion > (studioMaxVersion = this.studioUpgrades.lastKey().doubleValue())) {
            this.logger.error((Object)("Configured studio version (" + studioVersion + ") is older than currently running version (" + studioMaxVersion + "); have you downgraded your studio?"));
        } else if (studioVersion < studioMaxVersion) {
            UpgradeInfo ret = new UpgradeInfo();
            for (Map.Entry<Double, List<StudioUpgradeTask>> entry : this.getStudioUpgrades().entrySet()) {
                if (entry.getKey() <= studioVersion) continue;
                ret.setVersion(entry.getKey());
                for (StudioUpgradeTask task : entry.getValue()) {
                    task.doUpgrade(ret);
                }
                UpgradeManager.setStudioVersion(entry.getKey());
            }
            for (String version : ret.getMessages().keySet()) {
                for (String message : ret.getMessages().get(version)) {
                    this.logger.warn((Object)("Upgraded to " + version + ": " + message));
                }
            }
        }
    }

    public static double getStudioVersion() {
        String prefString = ConfigurationStore.getPreference(UpgradeManager.class, STUDIO_VERSION_KEY, "0.0");
        return Double.parseDouble(prefString);
    }

    public static void setStudioVersion(double version) {
        ConfigurationStore.setPreference(UpgradeManager.class, STUDIO_VERSION_KEY, "" + version);
    }

    public SortedMap<Double, List<UpgradeTask>> getUpgrades() {
        return this.upgrades;
    }

    public void setUpgrades(SortedMap<Double, List<UpgradeTask>> upgrades) {
        this.upgrades = upgrades;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public SortedMap<Double, List<StudioUpgradeTask>> getStudioUpgrades() {
        return this.studioUpgrades;
    }

    public void setStudioUpgrades(SortedMap<Double, List<StudioUpgradeTask>> studioUpgrades) {
        this.studioUpgrades = studioUpgrades;
    }
}

