/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public class UpgradeTemplateFile
implements UpgradeTask {
    private String relativePath;
    private String message;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        if (null == this.relativePath) {
            throw new WMRuntimeException("No file provided");
        }
        File localFile = new File(project.getProjectRoot(), this.relativePath);
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream("com/wavemaker/tools/project/templateapp.zip");
        ZipInputStream resourceZipStream = new ZipInputStream(resourceStream);
        try {
            ZipEntry zipEntry = null;
            while ((zipEntry = resourceZipStream.getNextEntry()) != null) {
                if (!this.relativePath.equals(zipEntry.getName())) continue;
                Writer writer = project.getWriter(localFile);
                IOUtils.copy((InputStream)resourceZipStream, (Writer)writer);
                writer.close();
            }
            resourceZipStream.close();
            resourceStream.close();
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        if (null != this.message) {
            upgradeInfo.addMessage(this.message);
        }
    }

    public void setFile(String file) {
        this.relativePath = file;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

