/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.five_dot_zero;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.ProjectUtils;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.beans.Bean;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;

public class AddServiceWireUpgradeTask
implements UpgradeTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        DesignServiceManager dsm = DesignTimeUtils.getDSMForProjectRoot(project.getProjectRoot());
        try {
            dsm.getDeploymentManager().build();
            this.upgradeServices(dsm, project, upgradeInfo);
        }
        finally {
            dsm.getDeploymentManager().cleanBuild();
        }
    }

    private void upgradeServices(DesignServiceManager dsm, Project project, UpgradeInfo upgradeInfo) {
        ArrayList<String> touchedServices = new ArrayList<String>();
        ClassLoader cl = ProjectUtils.getClassLoaderForProject(project);
        for (Service service : dsm.getServices()) {
            if ("runtimeService".equals(service.getId())) continue;
            if (null == service.getSpringFile()) {
                throw new WMRuntimeException(Resource.ADD_SRV_UPGRADE_NO_SPRING_FILE, new Object[]{project.getProjectName()});
            }
            File springFile = new File(dsm.getServiceRuntimeDirectory(service.getId()), service.getSpringFile());
            try {
                if (null == springFile || !springFile.exists()) {
                    DesignServiceManager.generateSpringServiceConfig(service.getId(), service.getClazz(), dsm.getDesignServiceType(service.getType()), springFile, project);
                    continue;
                }
                Beans beans = SpringConfigSupport.readBeans(springFile, project);
                boolean foundServiceWire = false;
                for (Bean bean : beans.getBeanList()) {
                    if (null == bean.getClazz()) continue;
                    Class<?> klass = cl.loadClass(bean.getClazz());
                    Class<?> serviceWireClass = cl.loadClass(ServiceWire.class.getName());
                    if (!serviceWireClass.isAssignableFrom(klass)) continue;
                    foundServiceWire = true;
                    break;
                }
                if (foundServiceWire) continue;
                Bean serviceWireBean = DesignServiceManager.generateServiceWireBean(dsm.getDesignServiceType(service.getType()), service.getId());
                beans.addBean(serviceWireBean);
                SpringConfigSupport.writeBeans(beans, springFile, project);
                touchedServices.add(service.getId());
            }
            catch (JAXBException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        }
        if (!touchedServices.isEmpty()) {
            upgradeInfo.addMessage("New ServiceWire added to services: " + StringUtils.join(touchedServices, (String)", "));
        }
    }
}

