/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.five_dot_zero;

import com.wavemaker.common.Resource;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.service.ServiceWire;
import com.wavemaker.runtime.service.events.EventWire;
import com.wavemaker.runtime.service.reflect.ReflectServiceWire;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.beans.Bean;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.spring.beans.DefaultableBoolean;
import com.wavemaker.tools.spring.beans.Property;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.xml.bind.JAXBException;

public class EventWireUpgradeTask
implements UpgradeTask {
    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        DesignServiceManager dsm = DesignTimeUtils.getDSMForProjectRoot(project.getProjectRoot());
        SortedSet<Service> services = dsm.getServices();
        for (Service service : services) {
            if ("runtimeService".equals(service.getId())) continue;
            File beanFile = new File(dsm.getServiceRuntimeDirectory(service.getId()), service.getSpringFile());
            boolean changed = false;
            try {
                String id;
                Beans beans = SpringConfigSupport.readBeans(beanFile, project);
                List<Bean> serviceWireBeans = beans.getBeansByType(ServiceWire.class);
                serviceWireBeans.addAll(beans.getBeansByType(ReflectServiceWire.class));
                if (serviceWireBeans.size() > 1 || serviceWireBeans.isEmpty()) {
                    throw new WMRuntimeException(Resource.PROJECT_TOO_MANY_SERVICE_WIRES, new Object[]{service.getId(), serviceWireBeans});
                }
                Bean serviceWire = serviceWireBeans.get(0);
                if (null != serviceWire.getId()) {
                    id = serviceWire.getId();
                } else {
                    changed = true;
                    id = service.getId() + "ServiceWire";
                    serviceWire.setId(id);
                }
                for (Bean bean : beans.getBeansByType(EventWire.class)) {
                    ArrayList<Property> toRemove = new ArrayList<Property>();
                    for (Object o : bean.getMetasAndConstructorArgsAndProperties()) {
                        Property p;
                        if (!(o instanceof Property) || !(p = (Property)o).getName().equals("bean")) continue;
                        toRemove.add(p);
                    }
                    for (Property p : toRemove) {
                        bean.getMetasAndConstructorArgsAndProperties().remove(p);
                        changed = true;
                    }
                    if (null == bean.getProperty("serviceWire")) {
                        Property p = new Property();
                        p.setName("serviceWire");
                        p.setRef(id);
                        bean.addProperty(p);
                        changed = true;
                    }
                    if (!bean.getLazyInit().equals((Object)DefaultableBoolean.TRUE)) continue;
                    changed = true;
                    bean.setLazyInit(null);
                }
                if (!changed) continue;
                SpringConfigSupport.writeBeans(beans, beanFile, project);
            }
            catch (JAXBException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
        }
    }
}

