/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.five_dot_zero;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.ConfigurationCompiler;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.beans.Beans;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

public class RemoveServiceManagerUpgradeTask
implements UpgradeTask {
    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File managersXml = ConfigurationCompiler.getRuntimeManagersXml(project);
        try {
            Beans beans = SpringConfigSupport.readBeans(managersXml, project);
            if (null != beans.getBeanById("serviceManager")) {
                beans.removeBeanById("serviceManager");
                SpringConfigSupport.writeBeans(beans, managersXml, project);
                upgradeInfo.addMessage("Removed servicesManager from project-services.xml");
            }
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }
}

