/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.five_dot_zero;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class WebXmlUpgradeTask
implements UpgradeTask {
    protected static final String WEB_XML_BACKUP = "web.xml.4_5_bak";

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File webXml = new File(project.getWebInf(), "web.xml");
        if (webXml.exists()) {
            File webXmlBak = new File(project.getWebInf(), WEB_XML_BACKUP);
            try {
                FileUtils.copyFile((File)webXml, (File)webXmlBak);
                webXml.delete();
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            File userWebXml = new File(project.getWebInf(), "user-web.xml");
            InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream("com/wavemaker/tools/project/templateapp.zip");
            ZipInputStream resourceZipStream = new ZipInputStream(resourceStream);
            try {
                ZipEntry zipEntry = null;
                while ((zipEntry = resourceZipStream.getNextEntry()) != null) {
                    if (!"webapproot/WEB-INF/user-web.xml".equals(zipEntry.getName())) continue;
                    Writer writer = project.getWriter(userWebXml);
                    IOUtils.copy((InputStream)resourceZipStream, (Writer)writer);
                    writer.close();
                }
                resourceZipStream.close();
                resourceStream.close();
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            upgradeInfo.addMessage("The web.xml file has changed.  If you have custommodifications, please copy them from web.xml.4_5_bak to the new user-web.xml.");
        }
    }
}

