/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.six_dot_one;

import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ProjSpringAppXmlUpgradeTask
implements UpgradeTask {
    private String fromStr = "/modules/**=wmModuleController";
    private String toStr = this.fromStr + "\r\n\r\n\t\t\t\t/lib/build/Gzipped/*=fileController" + "\r\n\t\t\t\t/lib/build/themes/**=fileController" + "\r\n\t\t\t\t/lib/wm/base/widget/themes/**=fileController" + "\r\n\t\t\t\t/lib/dojo/**=fileController" + "\r\n\t\t\t\t/lib/runtimeLoader.js=fileController" + "\r\n\t\t\t\t/lib/boot/boot.js=fileController";
    private boolean error = false;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File file = new File(project.getWebInf() + "/project-springapp.xml");
        try {
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            content = content.replace(this.fromStr, this.toStr);
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error = true;
        }
        if (this.error) {
            upgradeInfo.addMessage("*** Terminated with error while upgrading project-springapp.xml. Please check the console message.***");
        } else {
            upgradeInfo.addMessage("Upgrading project-springapp.xml completed successfully.");
        }
    }
}

