/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.six_dot_one;

import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class WebXmlUpgradeTask
implements UpgradeTask {
    private String str1 = "<url-pattern>*.upload</url-pattern>";
    private String str2 = "</servlet-mapping>";
    private String toStr = "<url-pattern>*.upload</url-pattern>\r\n\t</servlet-mapping>\r\n\r\n\t<servlet-mapping>\r\n\t\t<servlet-name>springapp</servlet-name>\r\n\t\t<url-pattern>/lib/build/Gzipped/*</url-pattern>\r\n\t</servlet-mapping>\r\n\r\n\t<servlet-mapping>\r\n\t\t<servlet-name>springapp</servlet-name>\r\n\t\t<url-pattern>/lib/build/themes/*</url-pattern>\r\n\t</servlet-mapping>\r\n\r\n\t<servlet-mapping>\r\n\t\t<servlet-name>springapp</servlet-name>\r\n\t\t<url-pattern>/lib/wm/base/widget/themes/*</url-pattern>\r\n\t</servlet-mapping>\r\n\r\n\t<servlet-mapping>\r\n\t\t<servlet-name>springapp</servlet-name>\r\n\t\t<url-pattern>/lib/dojo/*</url-pattern>\r\n\t</servlet-mapping>\r\n\r\n\t<servlet-mapping>\r\n\t\t<servlet-name>springapp</servlet-name>\r\n\t\t<url-pattern>/lib/boot/boot.js</url-pattern>\r\n\t</servlet-mapping>\r\n\r\n\t<servlet-mapping>\r\n\t\t<servlet-name>springapp</servlet-name>\r\n\t\t<url-pattern>/lib/runtimeLoader.js</url-pattern>\r\n\t</servlet-mapping>";
    private boolean error = false;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File webxml = project.getWebXml();
        try {
            String content = FileUtils.readFileToString((File)webxml, (String)"UTF-8");
            int indx1 = content.indexOf(this.str1);
            int indx2 = content.indexOf(this.str2, indx1);
            String fromStr = content.substring(indx1, indx2 + this.str2.length());
            content = content.replace(fromStr, this.toStr);
            FileUtils.writeStringToFile((File)webxml, (String)content, (String)"UTF-8");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error = true;
        }
        if (this.error) {
            upgradeInfo.addMessage("*** Terminated with error while upgrading web.xml. Please check the console message.***");
        } else {
            upgradeInfo.addMessage("Upgrading web.xml completed successfully.");
        }
    }
}

