/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.six_dot_one;

import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class WebXmlUpgradeTask1
implements UpgradeTask {
    private String fromStr = "<url-pattern>/lib/runtimeLoader.js</url-pattern>";
    private String toStr = this.fromStr + "\r\n\t</servlet-mapping>" + "\r\n\r\n\t<servlet-mapping>" + "\r\n\t\t<servlet-name>springapp</servlet-name>" + "\r\n\t\t<url-pattern>/resources/gzipped/*</url-pattern>" + "\r\n\t</servlet-mapping>" + "\r\n\r\n\t<servlet-mapping>" + "\r\n\t\t<servlet-name>springapp</servlet-name>" + "\r\n\t\t<url-pattern>/lib/runtimeLoader.js</url-pattern>";
    private boolean error = false;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File webxml = project.getWebXml();
        try {
            String content = FileUtils.readFileToString((File)webxml, (String)"UTF-8");
            content = content.replace(this.fromStr, this.toStr);
            FileUtils.writeStringToFile((File)webxml, (String)content, (String)"UTF-8");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error = true;
        }
        if (this.error) {
            upgradeInfo.addMessage("*** Terminated with error while upgrading web.xml. Please check the console message.***");
        } else {
            upgradeInfo.addMessage("Upgrading web.xml completed successfully.");
        }
    }
}

