/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.six_dot_two;

import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class ProjSecurityXmlUpgradeTask
implements UpgradeTask {
    private boolean error = false;
    private String[] fromStrs = new String[]{"org.acegisecurity.context.HttpSessionContextIntegrationFilter", "com.wavemaker.runtime.security.AcegiAjaxLogoutFilter", "org.acegisecurity.ui.webapp.AuthenticationProcessingFilter", "org.acegisecurity.providers.anonymous.AnonymousProcessingFilter", "com.wavemaker.runtime.security.JSONExceptionTranslationFilter", "org.acegisecurity.intercept.web.FilterSecurityInterceptor"};
    private String[] toStrs = new String[]{"com.wavemaker.runtime.security.WMHttpSessionContextIntegrationFilter", "com.wavemaker.runtime.security.WMAcegiAjaxLogoutFilter", "com.wavemaker.runtime.security.WMAuthenticationProcessingFilter", "com.wavemaker.runtime.security.WMAnonymousProcessingFilter", "com.wavemaker.runtime.security.WMExceptionTranslationFilter", "com.wavemaker.runtime.security.WMFilterSecurityInterceptor"};

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File secxml = project.getSecurityXml();
        try {
            String content = FileUtils.readFileToString((File)secxml, (String)"UTF-8");
            for (int i = 0; i < 6; ++i) {
                content = content.replace(this.fromStrs[i], this.toStrs[i]);
            }
            FileUtils.writeStringToFile((File)secxml, (String)content, (String)"UTF-8");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error = true;
        }
        if (this.error) {
            upgradeInfo.addMessage("*** Terminated with error while upgrading project-security.xml. Please check the console message.***");
        } else {
            upgradeInfo.addMessage("Upgrading project-security.xml completed successfully.");
        }
    }
}

