/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.six_dot_zero;

import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class SpringXmlUpgradeTask
implements UpgradeTask {
    private String fromStr = "com.wavemaker.common.WMPropertyPlaceholderConfigurer";
    private String toStr = "com.wavemaker.runtime.data.spring.WMPropertyPlaceholderConfigurer";
    private boolean processed = false;
    private boolean error = false;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        String svcPath = project.getProjectRoot() + "/services";
        File svc = new File(svcPath);
        File[] mdls = svc.listFiles();
        if (mdls == null || mdls.length == 0) {
            return;
        }
        for (File mdl : mdls) {
            File mdlsrc = new File(mdl.getAbsolutePath() + "/src");
            this.processSingleMdl(mdlsrc);
        }
        if (this.error) {
            upgradeInfo.addMessage("*** Terminated with error while upgrading Data Model Spring config file. Please check the console message.***");
        } else if (!this.processed) {
            upgradeInfo.addMessage("Upgrading Data Model Spring config file completed. No files processed.");
        } else {
            upgradeInfo.addMessage("Upgrading Data Model Spring config file completed successfully.");
        }
    }

    private void processSingleMdl(File mdl) {
        File[] xmls = mdl.listFiles();
        if (xmls == null || xmls.length == 0) {
            return;
        }
        for (File xmlf : xmls) {
            if (xmlf.isDirectory()) continue;
            this.processSingleXml(xmlf);
        }
    }

    private void processSingleXml(File xmlf) {
        String fileName = xmlf.getName();
        if (!fileName.contains("spring.xml")) {
            return;
        }
        try {
            String content = FileUtils.readFileToString((File)xmlf, (String)"UTF-8");
            content = content.replace(this.fromStr, this.toStr);
            FileUtils.writeStringToFile((File)xmlf, (String)content, (String)"UTF-8");
            this.processed = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error = true;
        }
    }
}

