/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.six_dot_zero;

import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class WebXmlUpgradeTask
implements UpgradeTask {
    private String wmListenerStr = "<listener-class>com.wavemaker.runtime.server.CleanupListener</listener-class>";
    private String springListenerStr = "<listener-class>org.springframework.web.context.ContextLoaderListener</listener-class>";
    private String dummyStr = "xxx123456789yyy";
    private boolean error = false;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File webxml = project.getWebXml();
        try {
            String content = FileUtils.readFileToString((File)webxml, (String)"UTF-8");
            int indxwm = content.indexOf(this.wmListenerStr);
            int indxspring = content.indexOf(this.springListenerStr);
            if (indxwm < indxspring) {
                return;
            }
            content = content.replace(this.wmListenerStr, this.dummyStr);
            content = content.replace(this.springListenerStr, this.wmListenerStr);
            content = content.replace(this.dummyStr, this.springListenerStr);
            FileUtils.writeStringToFile((File)webxml, (String)content, (String)"UTF-8");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error = true;
        }
        if (this.error) {
            upgradeInfo.addMessage("*** Terminated with error while upgrading web.xml. Please check the console message.***");
        } else {
            upgradeInfo.addMessage("Upgrading web.xml completed successfully.");
        }
    }
}

