/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.PagesManager;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import java.util.SortedSet;

public class AutoFormToLiveFormUpgrade
implements UpgradeTask {
    private PagesManager pagesManager;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        try {
            SortedSet<String> pages = this.getPagesManager().listPages();
            for (String page : pages) {
                File pageDir = this.getPagesManager().getPageDir(project.getProjectName(), page);
                File widgetsJS = new File(pageDir, page + "." + "widgets.js");
                if (!widgetsJS.exists()) continue;
                String contents = project.readFile(widgetsJS);
                contents = contents.replace("wm.AutoForm\"", "wm.LiveForm\"");
                project.writeFile(widgetsJS, contents);
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    public PagesManager getPagesManager() {
        return this.pagesManager;
    }

    public void setPagesManager(PagesManager pagesManager) {
        this.pagesManager = pagesManager;
    }
}

