/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.PagesManager;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class ClientSideRefactorUpgrade
implements UpgradeTask {
    public static final String BACKUP_EXT = "bak";
    public final Pattern panePagePattern = Pattern.compile("((?:operation|type):\\s*\")gotoPanePage(.*?\")", 32);
    public final String panePageReplaceStr = "$1gotoPageContainerPage$2";
    public final Pattern panePattern = Pattern.compile("(\\[\"wm.NavigationCall\".*?targetProperty:\\s\")pane(\".*?}])", 32);
    public final String paneReplaceStr = "$1pageContainer$2";
    public final Pattern serviceInputVariablePattern = Pattern.compile("(\\[\"wm.ServiceVariable\"[^\\]]*?\\[\")wm.Variable(\")", 32);
    public final String serviceInputVariableReplaceStr = "$1wm.ServiceInputVariable$2";
    protected final Pattern expressionPattern = Pattern.compile("(expression:\\s*\")(.*?)(\")");
    private PagesManager pagesManager;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        try {
            String contents;
            String contents2;
            File widgetsJS;
            File pageDir;
            String projectJS = project.getProjectName() + ".js";
            File fProjectJS = new File(project.getWebAppRoot(), projectJS);
            SortedSet<String> pages = this.getPagesManager().listPages();
            File webapp = project.getWebAppRoot();
            File indexhtml = new File(webapp, "index.html");
            if (indexhtml.exists()) {
                File bakIndexhtml = new File(webapp, "index.html.bak");
                FileUtils.copyFile((File)indexhtml, (File)bakIndexhtml);
                indexhtml.delete();
                upgradeInfo.addMessage("(generated) index.html renamed to index.html.bak");
            }
            if (fProjectJS.exists()) {
                String fProjectJSContents = project.readFile(fProjectJS);
                fProjectJSContents = ClientSideRefactorUpgrade.trimOutTypes(fProjectJSContents);
                project.writeFile(fProjectJS, fProjectJSContents);
            }
            for (String page : pages) {
                File pageJS;
                pageDir = this.getPagesManager().getPageDir(project.getProjectName(), page);
                widgetsJS = new File(pageDir, page + "." + "widgets.js");
                if (widgetsJS.exists()) {
                    contents2 = project.readFile(widgetsJS);
                    contents2 = contents2.replace("turbo.", "wm.");
                    project.writeFile(widgetsJS, contents2);
                }
                if (!(pageJS = new File(pageDir, page + "." + "js")).exists()) continue;
                String contents3 = project.readFile(pageJS);
                contents3 = contents3.replace("turbo.Part", "wm.Page");
                project.writeFile(pageJS, contents3);
            }
            if (fProjectJS.exists()) {
                contents = project.readFile(fProjectJS);
                contents = contents.replace("turbo.", "wm.");
                project.writeFile(fProjectJS, contents);
            }
            for (String page : pages) {
                pageDir = this.getPagesManager().getPageDir(project.getProjectName(), page);
                widgetsJS = new File(pageDir, page + "." + "widgets.js");
                if (!widgetsJS.exists()) continue;
                contents2 = project.readFile(widgetsJS);
                contents2 = contents2.replace("wm.ServiceCall", "wm.ServiceVariable");
                contents2 = contents2.replace("wm.Pane\"", "wm.PageContainer\"");
                project.writeFile(widgetsJS, contents2);
            }
            if (fProjectJS.exists()) {
                contents = project.readFile(fProjectJS);
                contents = contents.replace("wm.ServiceCall", "wm.ServiceVariable");
                contents = contents.replace("wm.Pane\"", "wm.PageContainer\"");
                project.writeFile(fProjectJS, contents);
            }
            for (String page : pages) {
                pageDir = this.getPagesManager().getPageDir(project.getProjectName(), page);
                widgetsJS = new File(pageDir, page + "." + "widgets.js");
                if (!widgetsJS.exists()) continue;
                contents2 = project.readFile(widgetsJS);
                contents2 = this.panePagePattern.matcher(contents2).replaceAll("$1gotoPageContainerPage$2");
                contents2 = this.panePattern.matcher(contents2).replaceAll("$1pageContainer$2");
                project.writeFile(widgetsJS, contents2);
            }
            for (String page : pages) {
                pageDir = this.getPagesManager().getPageDir(project.getProjectName(), page);
                widgetsJS = new File(pageDir, page + "." + "widgets.js");
                if (!widgetsJS.exists()) continue;
                contents2 = project.readFile(widgetsJS);
                Matcher matcher = this.expressionPattern.matcher(contents2);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String expression = matcher.group(2);
                    expression = Matcher.quoteReplacement(ClientSideRefactorUpgrade.upgradeExpression(expression));
                    matcher.appendReplacement(sb, "$1" + expression + "$3");
                }
                matcher.appendTail(sb);
                project.writeFile(widgetsJS, sb.toString());
            }
            for (String page : pages) {
                pageDir = this.getPagesManager().getPageDir(project.getProjectName(), page);
                widgetsJS = new File(pageDir, page + "." + "widgets.js");
                if (!widgetsJS.exists()) continue;
                contents2 = project.readFile(widgetsJS);
                contents2 = this.serviceInputVariablePattern.matcher(contents2).replaceAll("$1wm.ServiceInputVariable$2");
                project.writeFile(widgetsJS, contents2);
            }
            upgradeInfo.addMessage("widgets now use wm namespace (instead of turbo namespace)");
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    public static String trimOutTypes(String contents) {
        int endloc;
        int startloc = contents.indexOf("turbo.types");
        if (-1 != startloc) {
            endloc = ClientSideRefactorUpgrade.findEndLocation(contents, contents.indexOf(123, startloc) + 1, '{', '}', ';');
            contents = contents.substring(0, startloc) + contents.substring(endloc);
        }
        if (-1 != (startloc = contents.indexOf("turbo.primitives"))) {
            endloc = ClientSideRefactorUpgrade.findEndLocation(contents, contents.indexOf(123, startloc) + 1, '{', '}', ';');
            contents = contents.substring(0, startloc) + contents.substring(endloc);
        }
        contents = contents.trim();
        return contents;
    }

    public static String upgradeExpression(String expression) {
        if (expression.startsWith("%%")) {
            expression = expression.substring(2);
            expression = "Number(" + expression + ")";
        } else if (expression.startsWith("^^")) {
            expression = expression.substring(2);
            expression = "Boolean(" + expression + ")";
        } else {
            expression = "\\\"" + expression + "\\\"";
        }
        return expression;
    }

    private static int findEndLocation(String str, int start, char A, char B, char C) {
        int level = 1;
        while (start < str.length()) {
            if (str.charAt(start) == A) {
                ++level;
            } else if (str.charAt(start) == B) {
                --level;
            }
            ++start;
            if (0 != level) continue;
        }
        if (start < str.length() && C == str.charAt(start)) {
            ++start;
        }
        return start;
    }

    public PagesManager getPagesManager() {
        return this.pagesManager;
    }

    public void setPagesManager(PagesManager pagesManager) {
        this.pagesManager = pagesManager;
    }
}

