/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.config.ConfigurationStore;
import com.wavemaker.tools.project.StudioConfiguration;
import com.wavemaker.tools.project.upgrade.StudioUpgradeTask;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class CommonDirectoryMove
implements StudioUpgradeTask {
    public static final String UPGRADED_KEY = "COMMON_DIR_UPGRADED";
    private StudioConfiguration studioConfiguration;

    public void doUpgrade(UpgradeInfo upgradeInfo) {
        File commonDir = new File(this.studioConfiguration.getWaveMakerHome(), "common");
        boolean isUpgraded = ConfigurationStore.getPreferenceBoolean(this.getClass(), UPGRADED_KEY, false);
        if (commonDir.exists() && !isUpgraded) {
            File commonBakDir = new File(this.studioConfiguration.getStudioWebAppRootFile(), "lib/wm/common.bak");
            if (commonBakDir.exists()) {
                upgradeInfo.addMessage("Common backup directory (" + commonBakDir + ") already exists");
                return;
            }
            try {
                FileUtils.copyDirectory((File)commonDir, (File)commonBakDir);
                FileUtils.forceDelete((File)commonDir);
                this.studioConfiguration.getCommonDir();
            }
            catch (IOException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            ConfigurationStore.removePreference(this.getClass(), UPGRADED_KEY);
            upgradeInfo.addMessage("Your common directory has been moved to avoid conflicts and the template version copied in; if you have custom widgets, upgrade them manually from the backup at " + commonBakDir + ".");
        }
    }

    public StudioConfiguration getStudioConfiguration() {
        return this.studioConfiguration;
    }

    public void setStudioConfiguration(StudioConfiguration studioConfiguration) {
        this.studioConfiguration = studioConfiguration;
    }
}

