/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.service.events.EventWire;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.ConfigurationCompiler;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.EventNotifier;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.beans.Bean;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.spring.beans.DefaultableBoolean;
import com.wavemaker.tools.spring.beans.Property;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

public class EventRefactorUpgrade
implements UpgradeTask {
    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        DesignServiceManager dsm = DesignTimeUtils.getDSMForProjectRoot(project.getProjectRoot());
        try {
            for (Service service : dsm.getServices()) {
                if ("runtimeService".equals(service.getId()) || service.getEventnotifier().isEmpty()) continue;
                File beansFile = dsm.getServiceBeanXml(service.getId());
                Beans beans = SpringConfigSupport.readBeans(beansFile, project);
                for (EventNotifier event : service.getEventnotifier()) {
                    String existingBeanId = null;
                    for (Service srvc : dsm.getServices()) {
                        if (!srvc.getClazz().equals(event.getName())) continue;
                        existingBeanId = srvc.getId();
                    }
                    Bean eventWireBean = null != existingBeanId ? EventRefactorUpgrade.getEventWireBean(service.getId(), existingBeanId) : EventRefactorUpgrade.getEventWireBean_EmbeddedNotifier(service.getId(), event.getName());
                    beans.addBean(eventWireBean);
                }
                service.getEventnotifier().clear();
                dsm.defineService(service);
                SpringConfigSupport.writeBeans(beans, beansFile, project);
            }
            ConfigurationCompiler.generateManagers(project, ConfigurationCompiler.getRuntimeManagersXml(project), dsm.getServices());
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    public static Bean getEventWireBean(String serviceId, String eventRef) {
        Bean bean = new Bean();
        bean.setClazz(EventWire.class.getCanonicalName());
        bean.setLazyInit(DefaultableBoolean.TRUE);
        Property p = new Property();
        p.setName("eventListener");
        p.setRef(eventRef);
        bean.addProperty(p);
        p = new Property();
        p.setName("bean");
        p.setRef(serviceId);
        bean.addProperty(p);
        return bean;
    }

    public static Bean getEventWireBean_EmbeddedNotifier(String serviceId, String eventNotifierClass) {
        Bean bean = new Bean();
        bean.setClazz(EventWire.class.getCanonicalName());
        bean.setLazyInit(DefaultableBoolean.TRUE);
        Property p = new Property();
        p.setName("eventListener");
        Bean eventListenerBean = new Bean();
        eventListenerBean.setClazz(eventNotifierClass);
        p.setBean(eventListenerBean);
        bean.addProperty(p);
        p = new Property();
        p.setName("bean");
        p.setRef(serviceId);
        bean.addProperty(p);
        return bean;
    }
}

