/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class PanesRenameUpgrade
implements UpgradeTask {
    private static final String OLD_PANES_DIR = "panes";

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        try {
            File oldPanesDir = new File(project.getWebAppRoot(), OLD_PANES_DIR);
            if (!oldPanesDir.exists()) {
                return;
            }
            FileUtils.copyDirectory((File)oldPanesDir, (File)new File(project.getWebAppRoot(), "pages"));
            FileUtils.forceDelete((File)oldPanesDir);
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        upgradeInfo.addMessage("Moved old panes to new pages; static references to panes will have to be updated");
    }
}

