/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.security.DatabaseOptions;
import com.wavemaker.tools.security.DemoOptions;
import com.wavemaker.tools.security.DemoUser;
import com.wavemaker.tools.security.GeneralOptions;
import com.wavemaker.tools.security.LDAPOptions;
import com.wavemaker.tools.security.SecurityToolsManager;
import com.wavemaker.tools.service.DesignServiceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;

public class SecurityUpgrade
implements UpgradeTask {
    private DesignServiceManager dsm;

    public DesignServiceManager getDesignServiceManager() {
        return this.dsm;
    }

    public void setDesignServiceManager(DesignServiceManager dsm) {
        this.dsm = dsm;
    }

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        SecurityToolsManager stm = new SecurityToolsManager(this.dsm.getProjectManager(), this.dsm);
        try {
            block9: {
                boolean deleted = this.deleteSecurityService();
                if (deleted) {
                    upgradeInfo.addVerbose("Upgraded securityService");
                }
                try {
                    if (this.upgradeSpringBeanAndCreateService(stm)) {
                        upgradeInfo.addVerbose("Upgraded project-security.xml");
                    }
                }
                catch (ConfigurationException e) {
                    if (!deleted || this.dsm.serviceExists("securityService")) break block9;
                    stm.registerSecurityService();
                }
            }
            if (this.upgradeLoginHtml(project, stm)) {
                upgradeInfo.addVerbose("Renamed existing login.html to login.html.bak and regenerated a new one.");
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    private boolean deleteSecurityService() throws IOException, JAXBException, NoSuchMethodException {
        if (this.dsm.serviceExists("securityService")) {
            this.dsm.deleteService("securityService");
            return true;
        }
        return false;
    }

    private boolean upgradeSpringBeanAndCreateService(SecurityToolsManager stm) throws JAXBException, IOException {
        File acegiSpringFile = stm.getAcegiSpringFile();
        GeneralOptions generalOptions = stm.getGeneralOptions();
        if (generalOptions == null) {
            return false;
        }
        String dataSourceType = generalOptions.getDataSourceType();
        if (dataSourceType == null) {
            return false;
        }
        if (dataSourceType.equals("Demo")) {
            DemoOptions oldDemoOptions = stm.getDemoOptions();
            List<DemoUser> oldDemoUsers = oldDemoOptions.getUsers();
            ArrayList<DemoUser> demoUsers = new ArrayList<DemoUser>();
            for (DemoUser oldDemoUser : oldDemoUsers) {
                DemoUser demoUser = new DemoUser();
                demoUser.setUserid(oldDemoUser.getUserid());
                demoUser.setPassword(oldDemoUser.getPassword());
                demoUsers.add(demoUser);
            }
            acegiSpringFile.delete();
            stm.setGeneralOptions(generalOptions.isEnforceSecurity(), true);
            stm.configDemo(demoUsers.toArray(new DemoUser[0]));
        } else if (dataSourceType.equals("Database")) {
            DatabaseOptions oldDatabaseOptions = stm.getDatabaseOptions();
            acegiSpringFile.delete();
            stm.setGeneralOptions(generalOptions.isEnforceSecurity(), true);
            stm.configDatabase(oldDatabaseOptions.getModelName(), oldDatabaseOptions.getTableName(), oldDatabaseOptions.getUnameColumnName(), oldDatabaseOptions.getUidColumnName(), null, oldDatabaseOptions.getPwColumnName(), null, null);
        } else if (dataSourceType.equals("LDAP")) {
            LDAPOptions oldLDAPOptions = stm.getLDAPOptions();
            acegiSpringFile.delete();
            stm.setGeneralOptions(generalOptions.isEnforceSecurity(), true);
            stm.configLDAP(oldLDAPOptions.getLdapUrl(), oldLDAPOptions.getManagerDn(), oldLDAPOptions.getManagerPassword(), oldLDAPOptions.getUserDnPattern(), true, null, null, null);
        }
        return true;
    }

    private boolean upgradeLoginHtml(Project project, SecurityToolsManager stm) throws IOException {
        File webapp = project.getWebAppRoot();
        File loginHtml = new File(webapp, "login.html");
        if (loginHtml.exists()) {
            File loginTemplate = stm.getLoginHtmlTemplateFile();
            if (loginTemplate == null) {
                return false;
            }
            IOUtils.copy((File)loginHtml, (File)new File(webapp, "login.html.bak"));
            String loginContent = FileUtils.readFileToString((File)loginTemplate, (String)project.getEncoding());
            loginContent = loginContent.replace("{%PROJECT}", project.getProjectName());
            FileUtils.writeStringToFile((File)loginHtml, (String)loginContent, (String)project.getEncoding());
            return true;
        }
        return false;
    }
}

