/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;

public class ServiceBeanFileUpgrade
implements UpgradeTask {
    private static final JAXBContext definitionsContext;

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        DesignServiceManager dsm = DesignTimeUtils.getDSMForProjectRoot(project.getProjectRoot());
        ArrayList<String> touchedProjects = new ArrayList<String>();
        for (Service service : dsm.getServices()) {
            if (null != service.getSpringFile()) continue;
            File serviceBeanFile = dsm.getServiceBeanXml(service.getId());
            if (!serviceBeanFile.getParentFile().exists()) {
                serviceBeanFile.getParentFile().mkdir();
            }
            if (!serviceBeanFile.exists()) {
                try {
                    DesignServiceManager.generateSpringServiceConfig(service.getId(), service.getClazz(), dsm.getDesignServiceType(service.getType()), serviceBeanFile, project);
                }
                catch (JAXBException e) {
                    throw new WMRuntimeException((Throwable)e);
                }
                catch (IOException e) {
                    throw new WMRuntimeException((Throwable)e);
                }
            }
            File serviceDefFile = dsm.getServiceDefXml(service.getId());
            service.setSpringFile(serviceBeanFile.getName());
            try {
                Marshaller marshaller = definitionsContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.marshal((Object)service, serviceDefFile);
            }
            catch (JAXBException e) {
                throw new WMRuntimeException((Throwable)e);
            }
            touchedProjects.add(service.getId());
        }
        if (!touchedProjects.isEmpty()) {
            upgradeInfo.addVerbose("Converted bean definitions to a separate file for services: " + StringUtils.join(touchedProjects, (String)", "));
        }
    }

    static {
        try {
            definitionsContext = JAXBContext.newInstance((String)"com.wavemaker.tools.service.definitions");
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }
}

