/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.ConfigurationCompiler;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class WebInfActiveGridUpgrade
implements UpgradeTask {
    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        File webinf = project.getWebInf();
        File servicesConfig = ConfigurationCompiler.getRuntimeServicesXml(project);
        File managersConfig = ConfigurationCompiler.getRuntimeManagersXml(project);
        File webxml = new File(webinf, "web.xml");
        ArrayList<String> changedFiles = new ArrayList<String>();
        ArrayList<String> regenedFiles = new ArrayList<String>();
        DesignServiceManager dsm = DesignTimeUtils.getDSMForProjectRoot(project.getProjectRoot());
        try {
            if (servicesConfig.exists()) {
                ConfigurationCompiler.generateServices(project, servicesConfig, dsm.getServices());
                regenedFiles.add("project-services.xml");
            }
            if (managersConfig.exists()) {
                ConfigurationCompiler.generateManagers(project, managersConfig, dsm.getServices());
                regenedFiles.add("project-managers.xml");
            }
            if (webxml.exists()) {
                String webxmlContents = FileUtils.readFileToString((File)webxml, (String)"UTF-8");
                webxmlContents = webxmlContents.replace("com.activegrid.runtime.server.CleanupListener", "com.wavemaker.runtime.server.CleanupListener");
                webxmlContents = webxmlContents.replace("com.activegrid.runtime.security.AcegiAjaxFilter", "com.wavemaker.runtime.security.AcegiAjaxFilter");
                FileUtils.writeStringToFile((File)webxml, (String)webxmlContents, (String)"UTF-8");
                changedFiles.add("web.xml");
            }
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (JAXBException e2) {
            throw new WMRuntimeException((Throwable)e2);
        }
        String ret = null;
        if (!changedFiles.isEmpty()) {
            ret = "Removed com.activegrid references from " + StringUtils.join(changedFiles, (String)", ");
        }
        if (!regenedFiles.isEmpty()) {
            ret = null != ret ? ret + "\n" : "";
            ret = ret + "Re-generated files: " + StringUtils.join(regenedFiles, (String)", ");
        }
        upgradeInfo.addVerbose(ret);
    }
}

