/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.project.upgrade.swamis;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.upgrade.UpgradeInfo;
import com.wavemaker.tools.project.upgrade.UpgradeTask;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.ws.WebServiceToolsManager;
import com.wavemaker.tools.ws.wsdl.WSDLException;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

public class WebServiceUpgrade
implements UpgradeTask {
    private DesignServiceManager dsm;

    public DesignServiceManager getDesignServiceManager() {
        return this.dsm;
    }

    public void setDesignServiceManager(DesignServiceManager dsm) {
        this.dsm = dsm;
    }

    public void doUpgrade(Project project, UpgradeInfo upgradeInfo) {
        WebServiceToolsManager wstm = new WebServiceToolsManager(this.dsm.getProjectManager(), this.dsm);
        try {
            this.upgradeWebServices(wstm, upgradeInfo);
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        catch (WSDLException e) {
            throw new WMRuntimeException((Throwable)((Object)e));
        }
        catch (NoSuchMethodException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeWebServices(WebServiceToolsManager wstm, UpgradeInfo upgradeInfo) throws IOException, JAXBException, WSDLException, NoSuchMethodException {
        for (String serviceId : this.dsm.getServiceIds()) {
            Service service = this.dsm.getService(serviceId);
            if (service == null || !"WebService".equals(service.getType())) continue;
            if (serviceId.equals("FeedService")) {
                this.dsm.deleteService("FeedService");
                wstm.registerFeedService();
            } else {
                File wsdlFile = wstm.getWSDLFile(serviceId);
                if (wsdlFile != null) {
                    File tempDir = IOUtils.createTempDirectory();
                    try {
                        File tempWsdlFile = new File(tempDir, "temp.wsdl");
                        IOUtils.copy((File)wsdlFile, (File)tempWsdlFile);
                        this.dsm.deleteService(serviceId);
                        wstm.importWSDL(tempWsdlFile.getCanonicalPath(), null, true);
                    }
                    finally {
                        try {
                            IOUtils.deleteRecursive((File)tempDir);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            upgradeInfo.addVerbose("Upgraded " + serviceId);
        }
    }
}

