/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.security;

import com.wavemaker.common.util.IOUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.runtime.security.JOSSOSecurityService;
import com.wavemaker.runtime.security.SecurityService;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.security.DatabaseOptions;
import com.wavemaker.tools.security.DemoOptions;
import com.wavemaker.tools.security.DemoUser;
import com.wavemaker.tools.security.GeneralOptions;
import com.wavemaker.tools.security.JOSSOSecurityServiceDefinition;
import com.wavemaker.tools.security.LDAPOptions;
import com.wavemaker.tools.security.SecurityServiceDefinition;
import com.wavemaker.tools.security.SecuritySpringSupport;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.spring.SpringConfigSupport;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.webapp.WebXmlSupport;
import com.wavemaker.tools.webapp.schema.AuthConstraintType;
import com.wavemaker.tools.webapp.schema.AuthMethodType;
import com.wavemaker.tools.webapp.schema.FormLoginConfigType;
import com.wavemaker.tools.webapp.schema.HttpMethodType;
import com.wavemaker.tools.webapp.schema.LoginConfigType;
import com.wavemaker.tools.webapp.schema.RoleNameType;
import com.wavemaker.tools.webapp.schema.SecurityConstraintType;
import com.wavemaker.tools.webapp.schema.SecurityRoleType;
import com.wavemaker.tools.webapp.schema.String;
import com.wavemaker.tools.webapp.schema.TransportGuaranteeType;
import com.wavemaker.tools.webapp.schema.UrlPatternType;
import com.wavemaker.tools.webapp.schema.UserDataConstraintType;
import com.wavemaker.tools.webapp.schema.WarPathType;
import com.wavemaker.tools.webapp.schema.WebAppType;
import com.wavemaker.tools.webapp.schema.WebResourceCollectionType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.sql.DataSource;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.ldap.DefaultInitialDirContextFactory;
import org.acegisecurity.userdetails.jdbc.JdbcDaoImpl;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityToolsManager {
    static final Logger logger = Logger.getLogger(SecurityToolsManager.class);
    private static final java.lang.String ACEGI_SPRING_FILENAME = "project-security.xml";
    private static final java.lang.String ACEGI_SPRING_TEMPLATE_CLASSPATH = "com/wavemaker/tools/security/project-security-template.xml";
    private static final java.lang.String LOGIN_HTML_TEMPLATE_CLASSPATH = "com/wavemaker/tools/security/login-template.html";
    private ProjectManager projectMgr;
    private DesignServiceManager designServiceMgr;

    public SecurityToolsManager(ProjectManager projectMgr, DesignServiceManager designServiceMgr) {
        this.projectMgr = projectMgr;
        this.designServiceMgr = designServiceMgr;
    }

    private Beans getAcegiSpringBeansTemplate() throws JAXBException, IOException {
        ClassPathResource securityTemplateXml = new ClassPathResource(ACEGI_SPRING_TEMPLATE_CLASSPATH);
        InputStreamReader reader = new InputStreamReader(securityTemplateXml.getInputStream());
        Beans ret = SpringConfigSupport.readBeans(reader);
        ((Reader)reader).close();
        return ret;
    }

    public File getAcegiSpringFile() {
        return this.getAcegiSpringFile(this.projectMgr.getCurrentProject());
    }

    private File getAcegiSpringFile(Project currentProject) {
        return new File(currentProject.getWebInf(), ACEGI_SPRING_FILENAME);
    }

    private Beans getAcegiSpringBeans(boolean create) throws IOException, JAXBException {
        Project currentProject = this.projectMgr.getCurrentProject();
        File securityXml = this.getAcegiSpringFile(currentProject);
        Beans beans = null;
        if (securityXml.exists()) {
            try {
                beans = SpringConfigSupport.readBeans(securityXml, currentProject);
            }
            catch (JAXBException e) {
                if (create) {
                    beans = this.getAcegiSpringBeansTemplate();
                }
                throw e;
            }
        }
        if (create) {
            if (beans == null || beans.getBeanList().isEmpty()) {
                beans = this.getAcegiSpringBeansTemplate();
            }
            this.registerSecurityService();
        }
        return beans;
    }

    private void saveAcegiSpringBeans(Beans beans) throws JAXBException, IOException {
        Project currentProject = this.projectMgr.getCurrentProject();
        File securityXml = this.getAcegiSpringFile(currentProject);
        if (!securityXml.exists()) {
            IOUtils.makeDirectories((File)securityXml.getParentFile(), (File)currentProject.getProjectRoot());
        }
        SpringConfigSupport.writeBeans(beans, securityXml, currentProject);
    }

    public void registerSecurityService() {
        SortedSet<Service> services = this.designServiceMgr.getServices();
        boolean found = false;
        for (Service service : services) {
            if (!service.getClazz().equals(SecurityService.class.getName())) continue;
            found = true;
        }
        if (!found) {
            try {
                java.lang.String serviceId = "securityService";
                SortedSet<java.lang.String> serviceIds = this.designServiceMgr.getServiceIds();
                int i = 1;
                while (serviceIds.contains(serviceId)) {
                    serviceId = "securityService" + i;
                    ++i;
                }
                SecurityServiceDefinition def = new SecurityServiceDefinition(serviceId);
                this.designServiceMgr.defineService(def);
            }
            catch (LinkageError e) {
                throw new ConfigurationException(e);
            }
        }
    }

    public void registerJOSSOSecurityService() {
        SortedSet<Service> services = this.designServiceMgr.getServices();
        boolean found = false;
        for (Service service : services) {
            if (!service.getClazz().equals(JOSSOSecurityService.class.getName())) continue;
            found = true;
        }
        if (!found) {
            try {
                java.lang.String serviceId = "securityServiceJOSSO";
                SortedSet<java.lang.String> serviceIds = this.designServiceMgr.getServiceIds();
                int i = 1;
                while (serviceIds.contains(serviceId)) {
                    serviceId = "securityServiceJOSSO" + i;
                    ++i;
                }
                JOSSOSecurityServiceDefinition def = new JOSSOSecurityServiceDefinition(serviceId);
                this.designServiceMgr.defineService(def);
            }
            catch (LinkageError e) {
                throw new ConfigurationException(e);
            }
        }
    }

    public GeneralOptions getGeneralOptions() throws JAXBException, IOException {
        Beans beans = null;
        try {
            beans = this.getAcegiSpringBeans(false);
        }
        catch (UnmarshalException e) {
            return null;
        }
        if (beans == null || beans.getBeanList().isEmpty()) {
            if (this.getJOSSORoles().isEmpty()) {
                return null;
            }
            GeneralOptions optionsJOSSO = new GeneralOptions();
            optionsJOSSO.setEnforceSecurity(true);
            optionsJOSSO.setEnforceIndexHtml(false);
            optionsJOSSO.setDataSourceType("JOSSO");
            return optionsJOSSO;
        }
        GeneralOptions options = new GeneralOptions();
        options.setEnforceSecurity(SecuritySpringSupport.isSecurityEnforced(beans));
        options.setEnforceIndexHtml(SecuritySpringSupport.isIndexHtmlEnforced(beans));
        options.setDataSourceType(SecuritySpringSupport.getDataSourceType(beans));
        return options;
    }

    public void setGeneralOptions(boolean enforceSecurity, boolean enforceIndexHtml) throws IOException, JAXBException {
        Beans beans = this.getAcegiSpringBeans(true);
        SecuritySpringSupport.setSecurityResources(beans, enforceSecurity, enforceIndexHtml);
        this.saveAcegiSpringBeans(beans);
    }

    public void setGeneralOptions(boolean enforceSecurity) throws IOException, JAXBException {
        Beans beans = this.getAcegiSpringBeans(false);
        SecuritySpringSupport.setSecurityResources(beans, enforceSecurity, false);
        this.saveAcegiSpringBeans(beans);
    }

    public DemoOptions getDemoOptions() throws JAXBException, IOException {
        Beans beans = this.getAcegiSpringBeans(false);
        DemoOptions options = new DemoOptions();
        options.setUsers(SecuritySpringSupport.getDemoUsers(beans));
        return options;
    }

    public List<java.lang.String> getJOSSOOptions() throws JAXBException, IOException {
        ArrayList<java.lang.String> jossoRoles = new ArrayList<java.lang.String>();
        File webXml = this.projectMgr.getCurrentProject().getWebXml();
        WebAppType wat = WebXmlSupport.readWebXml(webXml);
        List<Object> watList = wat.getDescriptionAndDisplayNameAndIcon();
        for (Object element : watList) {
            if (!(element instanceof SecurityConstraintType)) continue;
            SecurityConstraintType secCon = (SecurityConstraintType)element;
            AuthConstraintType authCons = secCon.getAuthConstraint();
            List<RoleNameType> theRoles = authCons.getRoleName();
            for (RoleNameType thisRole : theRoles) {
                jossoRoles.add(thisRole.getValue());
            }
        }
        return jossoRoles;
    }

    public void setJOSSOOptions(java.lang.String primaryRole) throws JAXBException, IOException {
        boolean exists = false;
        this.designServiceMgr.getDeploymentManager().generateRuntime();
        File webXml = this.projectMgr.getCurrentProject().getWebXml();
        WebAppType wat = WebXmlSupport.readWebXml(webXml);
        List<Object> watList = wat.getDescriptionAndDisplayNameAndIcon();
        for (Object element : watList) {
            if (element instanceof SecurityConstraintType) {
                exists = true;
                SecurityConstraintType secCon = (SecurityConstraintType)element;
                AuthConstraintType authCons = secCon.getAuthConstraint();
                authCons.getRoleName().clear();
                RoleNameType roleName = new RoleNameType();
                roleName.setValue(primaryRole);
                authCons.getRoleName().add(roleName);
            }
            if (!(element instanceof SecurityRoleType)) continue;
            exists = true;
            SecurityRoleType secRole = (SecurityRoleType)element;
            RoleNameType theRole = secRole.getRoleName();
            theRole.setValue(primaryRole);
            secRole.setRoleName(theRole);
        }
        if (exists) {
            WebXmlSupport.writeWebXml(wat, webXml);
            return;
        }
        SecurityConstraintType secCons = new SecurityConstraintType();
        WebResourceCollectionType webResColl = new WebResourceCollectionType();
        String webString = new String();
        webString.setValue("protected-resource");
        webResColl.setWebResourceName(webString);
        UrlPatternType urlPat = new UrlPatternType();
        urlPat.setValue("/*");
        webResColl.getUrlPattern().add(urlPat);
        ArrayList<HttpMethodType> methods = new ArrayList<HttpMethodType>();
        HttpMethodType httpMetHead = new HttpMethodType();
        httpMetHead.setValue("HEAD");
        methods.add(httpMetHead);
        HttpMethodType httpMetGet = new HttpMethodType();
        httpMetGet.setValue("GET");
        methods.add(httpMetGet);
        HttpMethodType httpMetPost = new HttpMethodType();
        httpMetPost.setValue("POST");
        methods.add(httpMetPost);
        HttpMethodType httpMetPut = new HttpMethodType();
        httpMetPut.setValue("PUT");
        methods.add(httpMetPut);
        HttpMethodType httpMetDelete = new HttpMethodType();
        httpMetDelete.setValue("DELETE");
        methods.add(httpMetDelete);
        webResColl.getHttpMethod().addAll(methods);
        secCons.getWebResourceCollection().add(webResColl);
        AuthConstraintType authCons = new AuthConstraintType();
        RoleNameType roleName = new RoleNameType();
        roleName.setValue(primaryRole);
        authCons.getRoleName().add(roleName);
        UserDataConstraintType userDataCons = new UserDataConstraintType();
        TransportGuaranteeType transGuarantee = new TransportGuaranteeType();
        transGuarantee.setValue("NONE");
        userDataCons.setTransportGuarantee(transGuarantee);
        secCons.setAuthConstraint(authCons);
        secCons.setUserDataConstraint(userDataCons);
        wat.getDescriptionAndDisplayNameAndIcon().add(secCons);
        LoginConfigType loginConf = new LoginConfigType();
        AuthMethodType authMeth = new AuthMethodType();
        authMeth.setValue("FORM");
        loginConf.setAuthMethod(authMeth);
        FormLoginConfigType loginForm = new FormLoginConfigType();
        WarPathType loginPage = new WarPathType();
        loginPage.setValue("/login-redirect.jsp");
        loginForm.setFormLoginPage(loginPage);
        WarPathType errorPage = new WarPathType();
        errorPage.setValue("/login-redirect.jsp");
        loginForm.setFormErrorPage(errorPage);
        loginConf.setFormLoginConfig(loginForm);
        wat.getDescriptionAndDisplayNameAndIcon().add(loginConf);
        SecurityRoleType secRole = new SecurityRoleType();
        RoleNameType secRoleName = new RoleNameType();
        secRoleName.setValue(primaryRole);
        secRole.setRoleName(secRoleName);
        wat.getDescriptionAndDisplayNameAndIcon().add(secRole);
        WebXmlSupport.writeWebXml(wat, webXml);
    }

    public void configDemo(DemoUser[] demoUsers) throws JAXBException, IOException {
        Beans beans = this.getAcegiSpringBeans(true);
        SecuritySpringSupport.updateAuthProviderUserDetailsService(beans, "inMemoryDaoImpl");
        SecuritySpringSupport.setDemoUsers(beans, demoUsers);
        SecuritySpringSupport.resetJdbcDaoImpl(beans);
        this.saveAcegiSpringBeans(beans);
    }

    public DatabaseOptions getDatabaseOptions() throws IOException, JAXBException {
        Beans beans = this.getAcegiSpringBeans(false);
        return SecuritySpringSupport.constructDatabaseOptions(beans);
    }

    public void configDatabase(java.lang.String modelName, java.lang.String tableName, java.lang.String unameColumnName, java.lang.String uidColumnName, java.lang.String uidColumnSqlType, java.lang.String pwColumnName, java.lang.String roleColumnName, java.lang.String rolesByUsernameQuery) throws JAXBException, IOException {
        Beans beans = this.getAcegiSpringBeans(true);
        SecuritySpringSupport.updateAuthProviderUserDetailsService(beans, "jdbcDaoImpl");
        SecuritySpringSupport.updateJdbcDaoImpl(beans, modelName, tableName, unameColumnName, uidColumnName, uidColumnSqlType, pwColumnName, roleColumnName, rolesByUsernameQuery);
        this.saveAcegiSpringBeans(beans);
    }

    public List<java.lang.String> testRolesByUsernameQuery(DataModelConfiguration dataModel, java.lang.String query, java.lang.String username) {
        Properties properties = dataModel.readConnectionProperties();
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setUrl(properties.getProperty("connectionUrl"));
        dataSource.setDriverClassName(properties.getProperty("driverClassName"));
        dataSource.setUsername(properties.getProperty("username"));
        java.lang.String pwd = properties.getProperty("password");
        if (SystemUtils.isEncrypted((java.lang.String)pwd)) {
            pwd = SystemUtils.decrypt((java.lang.String)pwd);
        }
        dataSource.setPassword(pwd);
        JdbcDaoImplTest jdbcDaoImpl = new JdbcDaoImplTest();
        jdbcDaoImpl.setAuthoritiesByUsernameQuery(query);
        jdbcDaoImpl.setDataSource((DataSource)dataSource);
        jdbcDaoImpl.setRolePrefix("ROLE_");
        jdbcDaoImpl.initTest();
        return jdbcDaoImpl.loadUserRolesByUsername(username);
    }

    public LDAPOptions getLDAPOptions() throws IOException, JAXBException {
        Beans beans = this.getAcegiSpringBeans(false);
        return SecuritySpringSupport.constructLDAPOptions(beans);
    }

    public void configLDAP(java.lang.String ldapUrl, java.lang.String managerDn, java.lang.String managerPassword, java.lang.String userDnPattern, boolean groupSearchDisabled, java.lang.String groupSearchBase, java.lang.String groupRoleAttribute, java.lang.String groupSearchFilter) throws IOException, JAXBException {
        Beans beans = this.getAcegiSpringBeans(true);
        SecuritySpringSupport.setAuthManagerProviderBeanId(beans, "ldapAuthProvider");
        SecuritySpringSupport.updateLDAPDirContext(beans, ldapUrl, managerDn, managerPassword);
        SecuritySpringSupport.updateLDAAuthProvider(beans, userDnPattern, groupSearchDisabled, groupSearchBase, groupRoleAttribute, groupSearchFilter);
        SecuritySpringSupport.resetJdbcDaoImpl(beans);
        this.saveAcegiSpringBeans(beans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testLDAPConnection(java.lang.String ldapUrl, java.lang.String managerDn, java.lang.String managerPassword) {
        DefaultInitialDirContextFactory dirContext = new DefaultInitialDirContextFactory(ldapUrl);
        if (managerDn != null && managerDn.length() != 0) {
            dirContext.setManagerDn(managerDn);
            if (SystemUtils.isEncrypted((java.lang.String)managerPassword)) {
                managerPassword = SystemUtils.decrypt((java.lang.String)managerPassword);
            }
            dirContext.setManagerPassword(managerPassword);
        }
        DirContext context = null;
        try {
            context = dirContext.newInitialDirContext();
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new ConfigurationException(e);
                }
            }
        }
    }

    public List<java.lang.String> getRoles() throws IOException, JAXBException {
        Beans beans = this.getAcegiSpringBeans(false);
        if (beans == null || beans.getBeanList().isEmpty()) {
            return this.getJOSSORoles();
        }
        return SecuritySpringSupport.getRoles(beans);
    }

    public List<java.lang.String> getJOSSORoles() throws IOException, JAXBException {
        ArrayList<java.lang.String> roles = new ArrayList<java.lang.String>();
        try {
            File webXml = this.projectMgr.getCurrentProject().getWebXml();
            WebAppType wat = WebXmlSupport.readWebXml(webXml);
            List<Object> watList = wat.getDescriptionAndDisplayNameAndIcon();
            for (Object element : watList) {
                if (!(element instanceof SecurityConstraintType)) continue;
                SecurityConstraintType secCon = (SecurityConstraintType)element;
                AuthConstraintType authCons = secCon.getAuthConstraint();
                List<RoleNameType> roleTypes = authCons.getRoleName();
                Iterator<RoleNameType> roleItr = roleTypes.iterator();
                while (roleItr.hasNext()) {
                    RoleNameType roleElement;
                    RoleNameType rnt = roleElement = roleItr.next();
                    roles.add(rnt.getValue());
                }
            }
            return roles;
        }
        catch (FileNotFoundException FNE) {
            return roles;
        }
    }

    public void setJOSSORoles(List<java.lang.String> roles) throws IOException, JAXBException {
    }

    public void setRoles(List<java.lang.String> roles) throws IOException, JAXBException {
        Beans beans = this.getAcegiSpringBeans(true);
        SecuritySpringSupport.setRoles(beans, roles);
        this.saveAcegiSpringBeans(beans);
    }

    public File getLoginHtmlTemplateFile() throws IOException {
        ClassPathResource resource = new ClassPathResource(LOGIN_HTML_TEMPLATE_CLASSPATH);
        if (resource.exists()) {
            return resource.getFile();
        }
        return null;
    }

    public void removeJOSSOConfig() throws JAXBException, IOException {
        File webXml = this.projectMgr.getCurrentProject().getWebXml();
        WebAppType wat = WebXmlSupport.readWebXml(webXml);
        List<Object> watList = wat.getDescriptionAndDisplayNameAndIcon();
        Iterator<Object> itr = watList.iterator();
        SecurityConstraintType secCon = null;
        while (itr.hasNext()) {
            Object element = itr.next();
            if (!(element instanceof SecurityConstraintType)) continue;
            secCon = (SecurityConstraintType)element;
            secCon.getWebResourceCollection().clear();
            AuthConstraintType authCons = null;
            secCon.setAuthConstraint(authCons);
            UserDataConstraintType userDataCons = null;
            secCon.setUserDataConstraint(userDataCons);
        }
        wat.getDescriptionAndDisplayNameAndIcon().remove(secCon);
        LoginConfigType loginCon = null;
        for (Object element2 : watList) {
            if (!(element2 instanceof LoginConfigType)) continue;
            loginCon = (LoginConfigType)element2;
            AuthMethodType authMeth = null;
            loginCon.setAuthMethod(authMeth);
            FormLoginConfigType form = null;
            loginCon.setFormLoginConfig(form);
        }
        wat.getDescriptionAndDisplayNameAndIcon().remove(loginCon);
        SecurityRoleType secRole = null;
        for (Object element3 : watList) {
            if (!(element3 instanceof SecurityRoleType)) continue;
            secRole = (SecurityRoleType)element3;
            RoleNameType roleName = null;
            secRole.setRoleName(roleName);
        }
        wat.getDescriptionAndDisplayNameAndIcon().remove(secRole);
        WebXmlSupport.writeWebXml(wat, webXml);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JdbcDaoImplTest
    extends JdbcDaoImpl {
        private JdbcDaoImplTest() {
        }

        public void initTest() {
            this.initDao();
        }

        public List<java.lang.String> loadUserRolesByUsername(java.lang.String username) {
            List dbAuths = this.authoritiesByUsernameMapping.execute(username);
            ArrayList<java.lang.String> userRoles = new ArrayList<java.lang.String>();
            for (GrantedAuthority dbAuth : dbAuths) {
                java.lang.String dbAuthString = dbAuth.getAuthority();
                if (!dbAuthString.startsWith("ROLE_")) continue;
                userRoles.add(dbAuthString.substring("ROLE_".length()));
            }
            return userRoles;
        }
    }
}

